/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999

#ifndef _WFTK_MIXER_H
#define _WFTK_MIXER_H

#include <sigc++/object.h>
#if SIGC_MAJOR_VERSION == 1 && SIGC_MINOR_VERSION == 0
#include <sigc++/signal_system.h>
#else
#include <sigc++/signal.h>
#endif

#include <SDL/SDL_types.h>
#include <string>

namespace wftk {

class Music;
class Sample;

/// Wrapper class around the audio mixer
class Mixer : virtual public SigC::Object
{
//OBJECT
  
public:
  /// create a Mixer, use_sound = false will create a stub instead
  Mixer(bool use_sound);
  ///
  ~Mixer();
  /// access the Mixer instance
  static Mixer* instance() {return instance_ ? instance_ : new Mixer(true);}
  /// check whether sound is initialized, without calling instance() and initializing it
  static bool isInit() {return instance_ != 0;}
  /// returns true if the mixer is available
  bool audioAvailable() { return audio_open_; }
  /// get the song currently playing
  const Music* currentSong() const { return music_; }
  /// set number of channels shall get processed
  int setActiveChannels(int);
  /// set current song
  void setMusic(const std::string& s);
  /// set current song
  void setMusic(const Music&);
  /// begin background music
  void startMusic();
  /// halt background music
  void stopMusic();
  /// pause music at current playback stop
  void pauseMusic();
  /// resume playback if paused
  void resumeMusic();
  /// continue playback from beginning of song
  void rewindMusic();
  /// play sample where \p res is a named sample Resource
  void playSample(const std::string& s);
  /// play sample where \p res is a named sample Resource
  void playSample(const Sample&);
  /// set volume to play samples at
  int setVolume(int);
  /// set volume to play music at
  int setMusicVolume(int);
  /// get current music volume
  int getMusicVolume() const {return volume_;}

  /** Enable visualization / filtering hook.
      (@ref data)
   */
  void enableHook(bool);
  
  /**Signal data.
     When the visualization hook is enabled, this signals is emitted whenever
     new data is to be send to the sounddevice.
     \param ptr and length of sample data.
  */
  SigC::Signal2<void, Uint8*, int> data;

 private:
  // unimplemented
  Mixer(const Mixer&);
  Mixer& operator=(const Mixer&);

  ///
  bool audio_open_;
  ///
  static void mixer_callback(void*, Uint8*, int);

  ///
  int audio_rate_;
  ///
  Uint16 audio_format_;
  ///
  int audio_channels_;

  ///
  const Music* music_;
  ///
  int volume_;

  ///
  static Mixer* instance_;
};

} // namespace wftk

#endif // _WFTK_MIXER_H
