/***************************************************************************
                          dcupdatemanager.h  -  description
                             -------------------
    begin                : Sun May 2 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCUPDATEMANAGER_H
#define DCUPDATEMANAGER_H

/**
  *@author Mathias Kster
  */

#include <DCDialogUpdateManager.h>
#include <qwidget.h>

#include <dclib/core/cthread.h>
#include <dclib/core/cstringlist.h>

#include <qtimer.h>

class CObject;
class CHttp;
class CByteArray;

/** */
class DCUpdateEntry : public CObject {
public:
	/** */
	DCUpdateEntry() {};
	/** */
	virtual ~DCUpdateEntry() {};

	/** */
	CString m_sName;
	/** */
	CString m_sVersion;
	/** */
	ulonglong m_nTime;
	/** */
	CString m_sUrl;
	/** */
	CString m_sComp;
};

/** */
class DCUpdateManager : public DCDialogUpdateManager {
Q_OBJECT

public:
	/** construtor */
	DCUpdateManager(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCUpdateManager();

	/** */
	void InitDocument();

protected:
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) { };

private:
	/** http callback function */
	int HttpCallBack( CObject *, CObject * );
	/** callback function */
	int DC_CallBack( CObject * );
	/** parse a config from bytearray */
	CList<DCUpdateEntry> * ParseConfig( CByteArray * in );
	/** check if new update available */
	void CheckConfig( CByteArray * in );
	/** save local update.xml */
	void SaveConfig( CList<DCUpdateEntry> * list );
	/** load local update.xml */
	CList<DCUpdateEntry> * LoadConfig();
	/** save content */
	bool SaveContent( DCUpdateEntry * entry, CByteArray * in );
	/** get new url */
	bool GetUrl( CString url );
	/** */
	void AppendLog( QString s );

	/** */
	QTimer m_Timer;
	/** */
	CString m_sUrl;
	/** */
	time_t m_Timeout;
	/** */
	bool m_bRun;
	/** */
	CThread m_UMThread;
	/** */
	CHttp * m_pHttp;
	/** */
	CList<CObject> * m_pMessageList;
	/** */
	CList<DCUpdateEntry> * m_pUpdateListNew;
	/** */
	CList<DCUpdateEntry> * m_pUpdateListOld;
	/** */
	bool m_bUpdate;
	
private slots:
	/** */
	void timerDone();
	/** */
	void slotUpdate();
	/** */
	void slotCheckUpdate();
};

/** */
extern DCUpdateManager * g_pUpdateManager;

#endif
