/***************************************************************************
                          dcfiletransferinfo.cpp  -  description
                             -------------------
    begin                : Sam Jul 13 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qprogressbar.h>

#include <dclib/dcos.h>
#include <dclib/cdownloadqueue.h>
#include <dclib/cutils.h>

#include <dcconfig.h>
#include <dctransferview.h>

#include "dcfiletransferinfo.h"

/** */
DCFileTransferInfo::DCFileTransferInfo( CString filename )
{
	m_sFileName = filename;

	InitDocument();

	connect( &m_Timer, SIGNAL(timeout()), SLOT(timerDone()) );

	m_Timer.start( 0, TRUE );
}

/** */
DCFileTransferInfo::~DCFileTransferInfo()
{
	m_Timer.stop();
}

/** */
void DCFileTransferInfo::InitDocument()
{
	DCFileChunkObject * pFileChunk;

	if ( g_pTransferView )
	{
		if ( (pFileChunk=g_pTransferView->DLM_QueueGetFileChunk(m_sFileName)) != 0 )
		{
			LineEdit_FILENAME->setText( pFileChunk->m_sLocalFile.Data() );
			LineEdit_HASH->setText( pFileChunk->m_sHash.Data() );
		}
	}
}

/** */
void DCFileTransferInfo::timerDone()
{
	int x1,x2;
	DCChunkObject * ChunkObject;
	DCFileChunkObject * pFileChunk;
	QPainter pa;
	QPixmap p(200,100);

	if ( g_pTransferView )
	{
		if ( (pFileChunk=g_pTransferView->DLM_QueueGetFileChunk(m_sFileName)) != 0 )
		{
			LineEdit_FILESIZE->setText( CString(CUtils::GetSizeString(pFileChunk->m_nSizeDone,g_pConfig->GetUnit()) +
					" / " + CUtils::GetSizeString(pFileChunk->m_nSize,g_pConfig->GetUnit())).Data() );
			LineEdit_SOURCES->setText( CString().setNum(pFileChunk->m_nReferenceCount).Data() );
			progressBar1->setTotalSteps((int) pFileChunk->m_nSize);
			progressBar1->setProgress((int) pFileChunk->m_nSizeDone);
			

			p.fill(Qt::white);
			pa.begin(&p);

			if ( pFileChunk->m_nSize != 0 )
			{
				ChunkObject = 0;

				while( (ChunkObject=pFileChunk->m_Chunks.Next(ChunkObject)) != 0 )
				{
					if ( ChunkObject->m_eChunkState == ecsFREE )
						pa.setPen( Qt::red );
					else
						pa.setPen( Qt::green );

					x1 = (ChunkObject->m_nStart*20000/pFileChunk->m_nSize);
        				x2 = (ChunkObject->m_nEnd*20000/pFileChunk->m_nSize);

					int ys,xs,ye,xe,y;

					xs = x1%200;
					ys = (x1-xs)/200;
					xe = x2%200;
					ye = (x2-xe)/200;

					// printf("%d %d %d %d\n",xs,xe,ys,ye);

					for(y=ys;y<=ye;y++)
					{
						if( (y==ys) && (y==ye) )
							pa.drawLine( xs, y, xe, y );
						else if ( y==ys )
							pa.drawLine( xs, y, 200, y );
						else if ( y==ye )
							pa.drawLine( 0, y, xe, y );
						else
							pa.drawLine( 0, y, 200, y );
					}
				}
			}

			pa.end();

			PixmapLabel_CHUNKINFO->setUpdatesEnabled(FALSE);
			PixmapLabel_CHUNKINFO->setPixmap(p);
			PixmapLabel_CHUNKINFO->setUpdatesEnabled(TRUE);
			PixmapLabel_CHUNKINFO->repaint();
		}
	}

	m_Timer.start( 5000, TRUE );
}
