/*
 *  database.h           -
 *
 *  Created: 20011226
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: database.h,v 1.11 2002/03/03 13:42:23 tomek Exp $
 *
 */

#ifndef __DATABASE_H
#define __DATABASE_H

#include <appointment-data.h>
#include <contact-data.h>

void db_init();
void db_close();

/* Typ uywane przez funkcje zwrotne (callback). */
typedef void (*appointment_callback)(appointment_data *item, void *data);

/* Funkcje suce do obsugi tabeli terminw. */
void db_appointment_add(appointment_data *data);
void db_appointment_update(appointment_data *data);
void db_appointment_foreach(appointment_callback callback, void *data);
void db_appointment_get(appointment_data *data, gint id);
void db_appointment_delete(gint id);

/* Typ uywane przez funkcje zwrotne (callback). */
typedef void (*contact_callback)(contact_data *item, void *data);

/* Funkcje suce do obsugi tabeli kontaktw. */
void db_contact_add(contact_data *data);
void db_contact_update(contact_data *data);
void db_contact_foreach(contact_callback callback, void *data);
void db_contact_get(contact_data *data, gint id);
void db_contact_delete(gint id);

#endif    /*  __DATABASE_H  */
