#!/usr/bin/perl -w
#
# Copyright 1995-2000 Timo Rossi, <trossi@iki.fi>
# See the file LICENSE for license terms.
#
# Script to create devices.c from devices.txt
#

@confignames = ( CP, WDTE, PWRTE, MCLRE, BODEN, MPEEN, LVP, CPD, WRT, BKBUG );
@oscnames = ( LP, XT, HS, RC, IN, INTRC, INTRC_CLKOUT,
	      EXTRC, EXTRC_CLKOUT, LF, EC );
@instrnames = ( "12BIT", "14BIT", "16BIT_NOMUL", "16BIT" );

%confidx = ();
for($i = 0; $i < @confignames; $i++) {
    $confidx{$confignames[$i]} = $i;
}

%oscidx = ();
for($i = 0; $i < @oscnames; $i++) {
    $oscidx{$oscnames[$i]} = $i;
}

%instridx = ();
for($i = 0; $i < @instrnames; $i++) {
    $instridx{$instrnames[$i]} = $i;
}

$ti = scalar(localtime);

print <<EOF;
/*
 * devices.c -- AUTOMATICALLY GENERATED FILE -- DO NOT EDIT
 *
 * created at $ti.
 *
 */

#include <stdio.h>
#include "picasm.h"

struct pic_type pic_types[] = {
EOF

while(<>) {
    next if(/^\s*($|\#)/);
    die "Device specification expected\n" unless(/^Device:\s*(.*?)\s*($|\#)/);

    $devname = $1;
    $devname =~ s/^PIC//i;
    undef $progmem;
    undef $regfile;
    undef $instrset;
    $eeprom = 0;
    @config = ();
    @osc = ();
    $oscmask = 0;
    $config_def = 0xffff;

    while(<>) {
	last if(/^\s*($|\#)/);
	if(/^ProgMem:\s*([^\s]*)\s*($|\#)/i) {
	    $progmem = number($1);
	    next;
	}
	if(/^Regfile:\s*([^\s]*)\s*($|\#)/i) {
	    $regfile = number($1);
	    next;
	}
	if(/^DataEeprom:\s*([^\s]*)\s*($|\#)/i) {
	    $eeprom = number($1);
	    next;
	}
	if(/^InstrSet:\s*([^\s]*)\s*($|\#)/i) {
	    $instrset = uc($1);
	    next;
	}
	if(/^Config_OSC:\s*([^\s]*)\s*([^\s]*)\s*($|\#)/i) {
	    my ($oscb, @osc1, $i);

	    $oscb = $1;
	    @osc1 = split('/', $2);
	    @osc = ();
	    for($i = 0; $i < @osc1; $i++) {
		$oscmask |= $i << $oscb;

		next if $osc1[$i] eq "";
		$oscidx = $oscidx{uc($osc1[$i])};
		die "Unknown oscillator type $osc1[$i]\n" unless defined $oscidx;

		$osc[$oscidx] = $i << $oscb;
	    }
	    next;
	}
	if(/^Config_Zero:\s*(.*?)\s*($|\#)/i) {
	    $config_def &= ~number($1);
	    next;
	}
	if(/^Config_(\w+):\s*(\~?)(.*?)\s*($|\#)/i) {
	    my ($confidx, $negflag, $confval);

	    $negflag = ($2 ne "" ? -1 : 1);
	    $confval = number($3);

	    $confidx = $confidx{$1};
	    die "Unknown config option $1\n" unless defined $confidx;

	    $config[$confidx] = $negflag * $confval;
	    next;
	}
    }

    die "Program memory size not defined for $devname\n"
    	unless defined($progmem);

    die "Register file size not defined for $devname\n"
	unless defined($regfile);

    die "Instruction set not defined for $devname\n"
	unless defined($instrset);

    die "Invalid instruction set for $devname\n"
	unless defined $instridx{$instrset};

    die "Missing oscillator definition for $devname\n"
	unless @osc > 0;

    $config[0] = 0 if @config == 0;

    $config_def &= 0x3fff if $instrset eq "14BIT";
    $config_def &= 0xfff if $instrset eq "12BIT";

    print "  {  \"$devname\",\n";
    print "     /*PROGMEM*/ $progmem, ";
    print "/*REGFILE*/ $regfile, ";
    print "/*EEPROM*/ $eeprom, ";
    print "/*INSTR*/ PIC$instrset,\n";

    $_ = sprintf "     /*CONFIG*/ 0x%x, { ", $config_def;
    for($i = 0; $i < @config; $i++) {
	my ($v, $vs);

	$_ .= ", " if $i > 0;

	if(length($_) > 60) {
	    print "$_\n";;
	    $_ = " " x 18;
	}

	$v = $config[$i];
	$v = 0 unless defined($v);

	if($v < 0) {
	    $vs = "-";
	    $v = -$v;
	} else {
	    $vs = "";
	}

	$_ .= sprintf "%s0x%x", $vs, $v;
	$_ .= " /*$confignames[$i]*/" if $v != 0;
    }
    print "$_ },\n";

    $_ = sprintf "     /*OSC*/ 0x%x, { ", $oscmask;
    for($i = 0; $i < @osc; $i++) {
	my $v;

	$_ .= ", " if $i > 0;
	if(length($_) > 60) {
	    print "$_\n";;
	    $_ = " " x 13;
	}
	$v = $osc[$i];
	if(defined($v)) {
	    $_ .= sprintf "0x%x /*%s*/", $v, $oscnames[$i];
	} else {
	    $_ .= "-1";
	}
    }
    print "$_ },\n  },\n";

    last if eof;
}

print "  { NULL } /*END MARKER*/\n};\n";
exit;

#
# parse a decimal or hex number
#
sub number
{
    my ($str) = @_;

    return oct($str) if($str =~ /^0x/i);
    return $str + 0;
}
