/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : ifdef.h
 * date    : 2000-03-15
 * modify  : 2001-06-15 by elcomski
 */
/* ----------------------------------------------- */
#ifndef _IFDEF_H_
#define _IFDEF_H_


/*--------------------------------*/
/* Constant definitions */
/*--------------------------------*/
#define SRL_MAX_DEVICE 10
#define SRL_MAX_PID 10
#define SRL_MAX_SIP 10
#define SRL_MAX_DIP 10
#define MAX_MAC_LISTS 10
#define SRL_MAX_UINT_LISTS 100
#define SRL_MAX_BYTE_LISTS 100

#define POWER_18V 1
#define POWER_13V 0

/* Begin Change for Fixed Key */
#define CW_SIZE 8
/* End Change for Fixed Key */


/*--------------------------------*/
/* Enum definitions */
/*--------------------------------*/
#ifndef _EN_VITERBI_468
#define _EN_VITERBI_468
typedef enum{
	FEC_AUTOMATIC,
	FEC_INNER_1_2,
	FEC_INNER_2_3,
	FEC_INNER_3_4,
	FEC_INNER_5_6,
	FEC_INNER_7_8
} EN_VITERBI_468;
#endif

#ifndef _LNB_CTRL
#define _LNB_CTRL
typedef enum{
	LNB_POL_VERTICAL,
	LNB_POL_HORIZONTAL,
	LNB_BAND_HIGH,
	LNB_BAND_LOW
} LNB_CTRL;
#endif

typedef enum{
	LNB_NONE,
	LNB_9300,
	LNB_9750,
	LNB_10000,
	LNB_10600,
	LNB_10750,
	LNB_11300,
	LNB_UNIVERSAL
}EN_LNB_TYPE;

typedef enum{
	BAND_KU,
	BAND_C
}EN_LNB_BAND;

typedef enum{
	DISEqC_Port1,
	DISEqC_Port2,
	DISEqC_Port3,
	DISEqC_Port4,
	DISEqC_Port5,
	DISEqC_Port6,
	DISEqC_Port7,
	DISEqC_Port8,
	DISEqC_Port9,
	DISEqC_Port10,
	DISEqC_Port11,
	DISEqC_Port12,
	DISEqC_Port13,
	DISEqC_Port14,
	DISEqC_Port15,
	DISEqC_Port16,
	DISEqC_None
}EN_DISEqC;


/*--------------------------------*/
/* Structure definitions */
/*--------------------------------*/
typedef struct struct_mac_data{
    	auint count;
    	auchar mac[MAX_MAC_LISTS][6];
	auint filterflags;
	auint mipflags;
}str_mac_data;

typedef struct struct_pid_data{
    	auint count;
    	auint pid[SRL_MAX_UINT_LISTS];
	auchar evencw[CW_SIZE];
	auchar oddcw[CW_SIZE];
}str_pid_data;

typedef struct struct_ip_data{
    	auint count;
    	auint ip[SRL_MAX_UINT_LISTS];
}str_ip_data;

struct str_base_data{
    	auint32 code;
	auint32 para0;
	auint32 para1;
	auint32 para2;
	auint32 para3;
	auint32 length;
};
	
typedef struct struct_io_data{
     	struct str_base_data base_data;
	union {
		abyte byte_buf[SRL_MAX_BYTE_LISTS];
		aulong long_buf[SRL_MAX_UINT_LISTS];
		auint32 dword_buf[SRL_MAX_UINT_LISTS];
		str_mac_data mac_data;
		str_pid_data pid_data;
	}spec;
}str_io_data;

typedef struct struct_trans_data{
    	achar sat_name[256];
	achar tp_name[256];
    	
	auint lnb_power_on_off;
	auint lnb_22khz_on_off;
	auint auto_pid;
	
	LNB_CTRL en_lnb_polar;     
	EN_LNB_TYPE en_lnb_type;
	EN_LNB_BAND en_lnb_band;
	EN_VITERBI_468 en_viterbi;
	EN_DISEqC en_diseqc;

	adouble symbol_rate;
	adouble local_frequency;
	adouble down_frequency;
}str_trans_data;

#endif // _IFDEF_H_
