/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : pentaif.h 
 * date    : 2000-03-15
 * modify  : 2001-12-13 by elcomski
 *
 */
/* ----------------------------------------------- */
#ifndef _PENTAIF_H_
#define _PENTAIF_H_


/*-------------------------------*/
/* Macro definitions */
/*-------------------------------*/
#define IoByteRead(a)     if_readb(a)
#define IoWordRead(a)     if_readw(a)
#define IoDwordRead(a)    if_readl(a)
#define IoByteWrite(a,b)  if_writeb(b,a)
#define IoWordWrite(a,b)  if_writew(b,a)
#define IoDwordWrite(a,b) if_writel(b,a)

#undef NULL
#if defined(__cplusplus)
#define NULL 0
#else
#define NULL ((void *)0)
#endif



/*-------------------------------*/
/* External Functions */
/*-------------------------------*/
extern void *if_kmalloc(unsigned int st,int m);
extern void if_kfree(const void *p);
extern unsigned long if_copy_from_user(void *src, void *dst, unsigned long ls);
extern void if_udelay(unsigned long lv);
extern void *if_memset(void *p, unsigned long lc, unsigned long lv);
extern void *if_memcpy(void *src, void *dst, unsigned long lv);
extern unsigned char if_readb(unsigned char *a);
extern unsigned short if_readw(unsigned char *a);
extern unsigned int if_readl(unsigned char *a);
extern void if_writeb(unsigned char b,unsigned char *a);
extern void if_writew(unsigned int b,unsigned char *a);
extern void if_writel(unsigned long b,unsigned char *a);

#endif // _PENTAIF_H_
