/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : pentaif.c 
 * date    : 2001-04-03
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#include <linux/modversions.h> /* to avoid unresolved symbol */
#include <linux/module.h>
#include <linux/version.h>

#include <linux/pci.h>
#include <linux/delay.h>       /* udelay */
#include <asm/uaccess.h>       /* copy_from_user( ) */ 



/*-------------------------------*/
/* Function definitions */
/*-------------------------------*/
/* 
 * func : if_kmalloc  
 * Context :
 */
void* if_kmalloc( unsigned int st, int m )
{
	return kmalloc((size_t)st,m);
}


/* 
 * func : if_kfree  
 * Context :
 */
void if_kfree( const void *p )
{
	return kfree(p);
}


/* 
 * func : if_copy_from_user  
 * Context :
 */
unsigned long if_copy_from_user(void *src, void *dst, unsigned long ls)
{
	return copy_from_user( src, dst, ls);
}


/* 
 * func : if_memset  
 * Context :
 */
void *if_memset(void *p, unsigned long lc, unsigned long lv)
{
	return memset(p, lc, lv);
}


/* 
 * func : if_udelay  
 * Context :
 */
void if_udelay(unsigned long lv)
{
	udelay(lv);
}


/* 
 * func : if_memcpy  
 * Context :
 */
void *if_memcpy(void *src, void *dst, unsigned long lv)
{
	return memcpy(src, dst, lv);
}


/* 
 * func : if_readb  
 * Context :
 */
unsigned char if_readb(unsigned char *a)
{
	return readb((unsigned long)a);
}


/* 
 * func : if_readw 
 * Context :
 */
unsigned short  if_readw(unsigned char *a)
{
	return readw((unsigned long)a);
}


/* 
 * func : if_readl
 * Context :
 */
unsigned int  if_readl(unsigned char *a)
{
	return readl((unsigned long)a);
}


/* 
 * func : if_writeb
 * Context :
 */
void if_writeb(unsigned char b,unsigned char *a)
{
    	writeb(b,(unsigned long)a);
}


/* 
 * func : if_writew
 * Context :
 */
void  if_writew(unsigned int b,unsigned char *a)
{
    	writew(b,(unsigned long)a);
}


/* 
 * func : if_writel
 * Context :
 */
void  if_writel(unsigned long b,unsigned char *a)
{
    	writel(b,(unsigned long)a);
}
