/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : hwdmx.h 
 * date    : 2001-06-14
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#ifndef _HWDMX_H_
#define _HWDMX_H_


/*-------------------------------*/
/* External Functions */
/*-------------------------------*/
extern void DmxInit( void );
extern void DmxDeinit( void );
extern void DmxInstall(void *pUcodeBuf,unsigned int UcodeSize, unsigned int DmxMode, unsigned int Flag );
extern void DmxStartCpu( void );
extern void DmxIrqInit( void );
extern void DmxIrqMaskAll( void );
extern void DmxIrqRestoreAll( void );

/*-------------------------------------*/
// I2C(qpsk/tuner) control 
/*-------------------------------------*/
extern void DmxReadI2c_for_tuner( unsigned int chip_addr, unsigned int *pDevData, unsigned int count );
extern void DmxReadI2c( unsigned int chip_addr, unsigned int offset, unsigned int *pDevData, unsigned int count );
extern void DmxWriteI2c_for_tuner( unsigned int chip_addr, unsigned int *pDevData, unsigned int count );
extern void DmxWriteI2c( unsigned int chip_addr, unsigned int offset, unsigned int *pDevData, unsigned int count );

extern unsigned int DmxWordRead( unsigned int addr );
extern void DmxWordWrite( unsigned int addr, unsigned int data );
extern unsigned int DmxGetWriteQHP( int queue );
extern void DmxQueueIntNextPos( int queue, unsigned long lstart, unsigned long lsize );
extern void DmxQueueIntNext( int queue );
extern void DmxIo( unsigned int cmd, unsigned int addr, unsigned int *pData, unsigned int count );
extern void DmxSetIpAddr( unsigned int IpAddr, unsigned int DataPid, unsigned int  Opt);
extern int DmxSetDataPidWithCw( unsigned int cmd, unsigned int Pid, unsigned char *EvenCw, unsigned char *OddCw );

#endif // _HWDMX_H_
