/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : avicos.c 
 * date    : 2000-08-20
 * modify  : 2002-11-11 by elcomski
 *
 */
/* ----------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "../../share/xptype.h"
#include "../../share/ifdef.h"
#include "../libif/pentapi.h"
#include "../libapp/avienv.h"
#include "../libapp/avienv1.h"
#include "../libapp/avifunc.h"
#include "tpdlg.h"
#include "msgdlg.h"
#include "fildlg.h"



/*--------------------------------*/
/* Constant definitions */
/*--------------------------------*/
#define PENTANETX_VER "2.3.1"


/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
char g_config_file[100];
char g_dirname2[256];
char g_dev_name[100] = "pentanet0";

str_trans_data g_trans_data;
str_pid_data g_pid_data;
str_ip_data g_dip_data;
str_ip_data g_sip_data;

int icount = 0;
int icount1 = 0;
int g_fd;
int g_iTimer;
int g_iChecklockTimer = 0; 
int g_card_status = 0;

GtkWidget *entry_index,*entry_data;
GtkWidget *radio_bridge;
GtkWidget *radio_local;
GtkWidget *button_read,*button_write;
GtkWidget *button_init,*button_exit,*button_quit;
GtkWidget *button_demux_init,*button_demux_exit;
GtkWidget *button_seek,*button_option;
GtkWidget *progressbar;
GtkWidget *status_label;
GtkWidget *lockstatus_label;
GtkWidget *skip_check;
GtkWidget *msg_label;
GtkWidget *data_label;
GtkWidget *speed_entry;
GtkWidget *lockstatus_entry;
GtkWidget *ber_entry;
GtkWidget *uncorrected_rs_err_entry;
GtkWidget *mac_addr_entry;
GtkWidget *snr_entry;
GtkWidget *devname_entry;



/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/*
 * Func : refresh_status
 * Context :
 */
void refresh_status( void )
{
	char sbuf[20];

	if( sm_tuner_get_status( g_dev_name) ){
		sprintf(sbuf,"lock");
	}else{ 
		sprintf(sbuf,"unlock");
	}
	gtk_entry_set_text(GTK_ENTRY(lockstatus_entry),sbuf);
}


/*
 * Func : time_process
 * Context : 
 * 	100ms Timer service routine
 */
gint time_process(gpointer data)
{
	static int ifirst = 1;
	float fData;
	char sbuf[256];
	char sbuf1[256];
	char sbuf2[256];
	auint32 nBPS = 0;
	float fBPS = 0;
	double fSnr = 0;
	int iBer = 0;
	int iRserr = 0;
	aint iret;
   
	icount++;
	if(icount >= 10){
		icount = 0;	

		/* firstly trying to lock */
		if(ifirst){
			ifirst = 0;
			iret = set_tuner(g_trans_data);
			if(iret == 1){
				set_pid_info( );
				sprintf(sbuf,"lock");
			}else{
				sprintf(sbuf,"unlock");
			}
			gtk_entry_set_text(GTK_ENTRY(lockstatus_entry),sbuf);
		}

		/* calculate the "signal quality(SNR[dB])" */
		fSnr = sm_get_signal_quality ( g_dev_name );
		if( fSnr >= 20.0 ){
			fData = 1.0;
		}else if ( fSnr <= 0.0 ){
			fData = 0.0;
		}else{
			fData = fSnr/20.0;
		}
		sprintf(sbuf,"%.02f[dB]",fSnr);

		/* calculate the "bit error rate(BER)" */	
		iBer = sm_get_bit_error_rate( g_dev_name);
	       	if( iBer > 0 ){
			sprintf(sbuf1,"%e\n", (float)iBer/1048576);
		}else if( iBer == 0 ){
			sprintf(sbuf1,"0");
		}else if( iBer < 0){
			sprintf(sbuf1,"Not supported");
		}

		/* compute the "uncorrected accumulated Reed solomon errors " */
		iRserr = sm_get_uncorrected_rs_error( g_dev_name);
		if( iRserr >= 0){
			sprintf(sbuf2,"%d", iRserr);
		}else if( iRserr < 0 ){
			sprintf(sbuf2,"Not supported");
		}

		gtk_progress_set_percentage(GTK_PROGRESS(progressbar),fData);
		gtk_entry_set_text(GTK_ENTRY(snr_entry),sbuf);
		gtk_entry_set_text(GTK_ENTRY(ber_entry),sbuf1);
		gtk_entry_set_text(GTK_ENTRY(uncorrected_rs_err_entry),sbuf2);

		/* calculate the "Rx data rate" */
		nBPS = sm_get_down_speed(g_dev_name);
		fBPS = (float)(nBPS * 8);
		fBPS = fBPS / (1024 * 1024);
		sprintf(sbuf,"%.3f[Mbps]",fBPS);
		gtk_entry_set_text(GTK_ENTRY(speed_entry),sbuf);
	}

	return TRUE;
}


/*
 * Func : Check_lockstatus
 * Context :
 * 	 100ms timer service  
 * 
 */
gint check_lockstatus( gpointer data )
{
	icount1++;
	if(icount1 >= 100){
		icount1 = 0;	
		/* set tuner status */
		refresh_status( );
	}

	return TRUE;
}


/*
 * Func : callback_seek
 * Context : 
 */
void callback_seek( GtkWidget *widget, gpointer data )
{
	satellite_dialog(&g_trans_data);
}


/*
 * Func : callback_option
 * Context :
 */
void callback_option( GtkWidget *widget, gpointer data ) 
{
	filter_dialog( );
}


/*
 * Func : delete_event
 * Context : 
 */
void delete_event( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	gtk_main_quit( );
}


/*
 * Func : draw_window
 * Context :  
 */
void draw_window( void )
{
	GtkWidget *window;
	GtkWidget *button;
	GtkWidget *table;

	GtkWidget *separator;
	GtkWidget *entry;

	GtkAdjustment *adj;
	GtkWidget *label;
	char sbuf[200];

	int xoptions = GTK_FILL | GTK_SHRINK;
	int yoptions = GTK_FILL | GTK_SHRINK;
	int xpadding = 5;
	int ypadding = 5; 

	char smacbuf[50];
	unsigned char bMacAddr[8];

	/* create a new window */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	/* set the window title */
	sprintf(sbuf,"Pent@NET for Linux (Ver %s)", PENTANETX_VER);
	gtk_window_set_title (GTK_WINDOW (window), sbuf);

	/* set a handler for delete_event that immediately exits GTK. */
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (delete_event), NULL);

	/* sets the border width of the window. */
	gtk_container_set_border_width (GTK_CONTAINER (window), 10);

	xoptions = GTK_FILL | GTK_EXPAND;
	yoptions = GTK_FILL | GTK_EXPAND;

	table = gtk_table_new (5, 4, FALSE);
	gtk_container_add( GTK_CONTAINER (window), table);
	gtk_widget_show( table);
   	
	/* create 'seek' button */
	button = gtk_button_new_with_label ("Seek");
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback_seek), (gpointer) "seek");
	gtk_widget_set_usize( button, 80, 20 );
	gtk_table_attach (GTK_TABLE (table), button, 0, 5, 8, 9, xoptions, yoptions, 5, 2);
	gtk_widget_show (button);
	button_seek = button;

	button = gtk_button_new_with_label ("Option");
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (callback_option), (gpointer) "option");
	gtk_widget_set_usize( button, 80, 20 );
	gtk_table_attach (GTK_TABLE (table), button, 0, 5, 9, 10, xoptions, yoptions, 5, 2);
	//gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, TRUE, 0);
	gtk_widget_show (button);
	button_option = button;

	label = gtk_label_new ("");
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
	gtk_misc_set_padding(GTK_MISC(label), 0, 0);
	gtk_widget_set_usize( label, 10, 20 );
	gtk_table_attach (GTK_TABLE (table), label, 1, 3, 5, 6, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

	/* create separator */
	separator = gtk_hseparator_new();
	gtk_table_attach (GTK_TABLE (table), separator, 0, 5, 7, 8, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(separator);

	/* enlarge the window */
	label = gtk_label_new ("");
	gtk_misc_set_alignment(GTK_MISC(label), 1 , 0.5);
	gtk_misc_set_padding(GTK_MISC(label), 0 , 0);
	gtk_widget_set_usize( label, 40, 20 );
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

	label = gtk_label_new ("");
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
	gtk_misc_set_padding(GTK_MISC(label), 0, 0);
	gtk_widget_set_usize( label, 40, 20 );
	gtk_table_attach (GTK_TABLE (table), label, 4, 5, 0, 1, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Device name label */
	label = gtk_label_new ("Device name");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Device name  entry  */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 100, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 0, 1, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	devname_entry = entry;

	sprintf(smacbuf,"%s", g_dev_name);
	gtk_entry_set_text(GTK_ENTRY(devname_entry),smacbuf);

 	/* Mac address label */
	label = gtk_label_new ("MAC address");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 1, 2, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Mac address entry  */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 100, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 1, 2, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	mac_addr_entry = entry;

	/* Calculate the "Mac address" when drawing window */
	sm_get_mac_address(g_dev_name, bMacAddr);
	sprintf(smacbuf,"%02x: %02x: %02x: %02x: %02x: %02x", bMacAddr[0],bMacAddr[1],bMacAddr[2], bMacAddr[3],bMacAddr[4],bMacAddr[5]);
	gtk_entry_set_text(GTK_ENTRY(mac_addr_entry),smacbuf);
	
	
 	/* Lock status label */
	label = gtk_label_new ("LNB lock status");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 2, 3, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Lock status entry */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 100, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 2, 3, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	lockstatus_entry = entry;

 	/* Rx data rate label */
	label = gtk_label_new ("Rx data rate");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 3, 4, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Rx data rate entry */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 100, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 3, 4, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	speed_entry = entry;
   
 	/* SNR label */
	label = gtk_label_new ("Signal-to-Noise Ratio");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 4, 5, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* SNR entry */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 140, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 4, 5, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	snr_entry = entry;
	
 	/* Bit error rate label */
	label = gtk_label_new ("Bit Error Rate");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 5, 6, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Bit error rate entry */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 120, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 5, 6, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	ber_entry = entry;

 	/* Uncorrected accumulated RS errors label */
	label = gtk_label_new ("Reed Solomon errors");
	gtk_misc_set_alignment(GTK_MISC(label),1,0.5);
	gtk_misc_set_padding(GTK_MISC(label),0,0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 6, 7, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(label);

 	/* Uncorrected accumulated RS errors entry */
	entry = gtk_entry_new ();
	gtk_entry_prepend_text(GTK_ENTRY(entry),"Tunning now");
	gtk_widget_set_usize( entry, 140, 20 );
	gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
	gtk_table_attach (GTK_TABLE (table), entry, 2, 5, 6, 7, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(entry);
	uncorrected_rs_err_entry = entry;

	/* progress */
	adj = (GtkAdjustment *) gtk_adjustment_new (0,0,100,0,0,0);
	progressbar = gtk_progress_bar_new_with_adjustment(adj);
	gtk_table_attach(GTK_TABLE(table), progressbar, 0, 5, 10, 11, xoptions,yoptions,xpadding,ypadding);
	gtk_widget_show(progressbar);
 
	gtk_widget_set_sensitive(button_seek,TRUE);
	gtk_widget_show (window);
}


/*
 * Func : main
 * Context :
 */
int main( int argc, char *argv[] )
{
    	int iret,opt,command;
	char *pstr;
	char sbuf[256];
    	
	strcpy(g_dirname2,argv[0]);
	pstr = strrchr(g_dirname2,'/');
	if(pstr){
		pstr[1] = 0;
	}else{
	    strcpy(g_dirname2,"./");
	}
	
	/* not use current directory path */
	g_dirname2[0] = 0;
	strcpy(g_config_file,"tp_test.penta");

	command = 1;
	while((opt = getopt(argc, argv, "f:d:")) != -1){
		switch(opt)
		{
			case 'f':
				strcpy(g_config_file,optarg);
			break;

			case 'd':
				strcpy(g_dev_name,optarg);
			break;
		
			case '?':
			{
				printf("**ERROR** unknown option : %c \n",optopt);
				command = 0;
			}
			break;
		}
	}		

	for(;optind < argc; optind++){
	    printf("**ERROR** unknown argument : %s \n",argv[optind]);
	}
	
	if( !command ) return -1;

	gtk_init (&argc, &argv);

    	InitTransInfo(g_dirname2);

    	draw_window();   

	get_if_list();

 	iret = sm_init_device(g_dev_name);
	if(iret < 0){
		if(iret == ERR_OPEN_SOCKET){
			printf("**ERROR** network interface open error\n");
		}else if(iret == ERR_NOT_DEVICE){
			printf("**ERROR** device not found\n");
		}else if(iret == ERR_NOT_DEVICE_OPEN){
			printf("**ERROR** device not open\n");
		}else{
			printf("**ERROR** unknown error code[%d]\n",iret);
		}

		msg_dialog(sbuf);
		gtk_widget_set_sensitive(button_seek,FALSE);
    		gtk_widget_set_sensitive(button_option,FALSE);
    		return -1;
	}else{
		/* trying to unlock */
		sm_tuner_stop_tunning( g_dev_name );

		/* initialize the device */
		iret = sm_init_device( g_dev_name);
		if(iret < 0 ){
			printf("**ERROR** device initialization error\n");
		}
		g_card_status = 1;

		/* addtimer for checking some stuff about the driver */
		g_iTimer = gtk_timeout_add( 100, (GtkFunction) time_process, NULL);

		/* addtimer for checking lock-status */
		g_iChecklockTimer = gtk_timeout_add ( 100 , (GtkFunction) check_lockstatus , NULL );
		
	}
     	
    	gtk_main( );
	
    	if(g_card_status){
		/* trying to unlock */
		sm_tuner_stop_tunning( g_dev_name );

		/* LNB power off */
	    	sm_lnb_set_power( g_dev_name, 0);

		/* exit the device */
		sm_exit_device(g_dev_name);

		/* Remove timer */
		gtk_timeout_remove( g_iTimer );

		/* Remove timer */
		gtk_timeout_remove( g_iChecklockTimer );
		
	}
    	
	WriteTransInfo(g_dirname2);
    	return 0;
}
