open GtkObj
open GtkEasy.Layout

(* A simple, step-by-step example using mlgtk *)

let hello_label = label_new "hello world!" 
  (* [GtkObj.label_new s] creates a widget label with caption [s] *)

let window_structure = Widget( hello_label :> widget ) 
  (* The structure of a window containing only the hello_label widget *)

let window = make_window_from_structure window_structure "Hello world window" 
  (* [make_window_from_structure] is a high-level function from
     GtkEasy.Layout that creates a window from a window structure.
     All the widgets are [#show]ed except the window itself, so it is
     still time to initialize things before displaying it *)
       
let _ = window #connect_delete_event( fun () -> GtkThr.main_quit(); false )
  (* The handler installed with the method [#connect_delete_event]
     is called when the user tries to close the window.  *)

let _ = window #show
  (* Show the window. *)

let _ = GtkThr.main ()
  (* And at last enter the event loop. *)
