// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MRAY_H
#define INCLUDED_MATH3D_MRAY_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mray.h,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3D_H
#include <math3d/m3d.h>
#endif

namespace Math3d {
  
/** 
 * 3-dimensional ray.
 */
  class _CCMATH3D MRay {
    protected:
      M3d d_pos;
      M3d d_dir;
    public:
      MRay();
      MRay(const M3d& pos, const M3d& dir);
      MRay(const MRay& ray);

      const MRay& operator=(const MRay& ray);
      void copy(const MRay& ray);
      
      void setPos(const M3d& pos);
      void setDir(const M3d& dir);
      void set(const M3d& p, const M3d& q);
      void setTgt(const M3d& tgt);

      M3d getPos() const {return(d_pos);}
      M3d getDir() const {return(d_dir);}
      M3d getTgt() const;
      M3d evaluate(double t) const;

      bool operator==(const MRay& ray) const;
      bool operator!=(const MRay& ray) const;
      bool cmp(const MRay& ray, double epsilon=EPSILON) const;
  };

}
#endif // INCLUDED_MATH3D_MRAY_H





