// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MBOUNDINGBOX_H
#define INCLUDED_MATH3D_MBOUNDINGBOX_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mboundingbox.h,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3D_H
#include <math3d/m3d.h>
#endif

namespace Math3d {
  
/*!
 * 3-dimensional axis aligned bounding box.
 */
  class _CCMATH3D MBoundingBox {
    protected:
      M3d d_min;
      M3d d_max;
    public:
      MBoundingBox();
      MBoundingBox(const M3d& p);
      MBoundingBox(const M3d& p, const M3d& q);
      MBoundingBox(const MBoundingBox& b);

      const MBoundingBox& operator=(const MBoundingBox& b);
      void copy(const MBoundingBox& b);
      
      void set(const M3d& p, const M3d& q);
      void extend(const M3d& p);
      void extend(const MBoundingBox& box);
      void transform(const M4x4& M);

      M3d getMin() const {return(d_min);}
      M3d getMax() const {return(d_max);}
      M3d getCenter() const;
      M3d getSize() const;
      bool isInside(const M3d& p) const;

      bool operator==(const MBoundingBox& b) const;
      bool operator!=(const MBoundingBox& b) const;
      bool cmp(const MBoundingBox& b, double epsilon=EPSILON) const;
  };

}
#endif // INCLUDED_MATH3D_MBOUNDINGBOX_H





