/***************************************************************************
                          smallwidget.cpp  -  description
                             -------------------
    begin                : Sam Jan 25 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smallwidget.h"

SmallWidget::SmallWidget(Options *opt, QWidget *parent, const char *name, WFlags f) : QWidget(parent,name,f)
{
	options = opt;

	/* move to the last position of the widget */
	int x;
	int y;
	options->getSmallPos(x, y);
	move(x, y);
	
	resize(105, 20);

	linkBar = new KProgress(this);
	linkBar->resize(width(), height());
	linkBar->move(0,0);
	linkBar->show();

	errorLabel = new QLabel(this);
	errorLabel->setText(*options->getNotString());
	errorLabel->resize(105, height());
	errorLabel->move(0,0);
	errorLabel->hide();

 	isCard = true;
	
  popup = new KPopupMenu(this);
  popup->insertItem("Close" , 1, 1);

  connect(popup, SIGNAL(activated(int)), this , SLOT(popupSlot(int)));
  
	hold = false;

	/* needed to get the resolution */
	desktop = QApplication::desktop();
}

SmallWidget::~SmallWidget(){
}

/** No descriptions */
void SmallWidget::mousePressEvent(QMouseEvent *ev)
{
  if( ev->button() == LeftButton )
  {
		xPress = ev->x();
		yPress = ev->y();
		hold=true;
	}
  if( ev->button() == RightButton )
  {
		popup->move(ev->globalPos());
		popup->exec();
	}
}

/** No descriptions */
void SmallWidget::mouseReleaseEvent(QMouseEvent *ev)
{
	hold = false;
	options->saveSmallPos(x(), y());
}

/** No descriptions */
void SmallWidget::mouseMoveEvent(QMouseEvent *ev)
{
	if(hold)
	{
		int x = ev->globalX() - xPress;
		int y = ev->globalY() - yPress;
  	if( x > desktop->width() - width())
   		x = desktop->width() - width();
		if( y > desktop->height() - height())
			y = desktop->height() - height();
		if( x < 0)
			x = 0;
		if( y < 0)
			y = 0;

		move(x, y);
	}
}

/** actualize link */
void SmallWidget::act(int value)
{
	if(value >= 0)
	{
		linkBar->setValue(value);
		
		if(!isCard)
		{
			isCard = true;
//s			resize(linkBar->width(), height());
			errorLabel->hide();		
			linkBar->show();
		}
			
	}else{
		if(isCard)
		{
			isCard = false;
//			resize(errorLabel->width(), height());
			linkBar->hide();
			errorLabel->show();
		}
	}
		
}

/** when a popop entry was activated */
void SmallWidget::popupSlot(int id)
{
	if(id==1)
		hide();
}
