/***************************************************************************
                          pollingspinbox.cpp  -  description
                             -------------------
    begin                : Sam Nov 23 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pollingspinbox.h"

PollingSpinBox::PollingSpinBox(int min, int max, int step, QWidget *parent, const char *name ) : QSpinBox(min, max, step, parent,name)
{
  QDoubleValidator *qdv = new QDoubleValidator(this);
  setValidator(qdv);
}
PollingSpinBox::~PollingSpinBox(){
}

QString PollingSpinBox::mapValueToText( int value )
{
  return QString( "%1.%2" ) // 0.0 to 10.0
         .arg( value / 10 ).arg( value % 10 );
}

int PollingSpinBox::mapTextToValue( bool *ok )
{
  return (int) ( 10 * text().toFloat() ); // 0 to 100
}
        