/***************************************************************************
                          ktray.cpp  -  description
                             -------------------
    begin                : Die Nov 12 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <klocale.h>
#include "ktray.h"

KTray::KTray(QWidget* parent, const char *name) : KSystemTray(parent, name)
{
  basicTimer = new QTimer(this);
  shortTimer = new QTimer(this);
  options = new Options();
  card = new WCard(options->getDevice()->data());

  for(int i=0; i<=9; i++)
  {
    QString s;
    s = *(options->getKwcDir()) + "kwaveq" + QString::number(i) + ".png";
    icons[i].load(s);
  }
  icons[10].load(*(options->getKwcDir()) + "kwaveqx.png");
  
  widget = new WWidget(card, options);
  widget->resize(270, 350);
  widget->hide();

  popup = contextMenu();

  openAction = new QAction(this, "open");
  openAction->setText(i18n ("Open") );
  openAction->setIconSet(QPixmap(*(options->getKwcDir()) + "open.png"));
  openAction->addTo(popup);
  connect(openAction, SIGNAL(activated()), this, SLOT(slotOpen()));
 
  

  closeAction = new QAction(this, "close");
  closeAction->setText(i18n ("Close") );
  closeAction->setIconSet(QPixmap(*(options->getKwcDir()) + "close.png"));
  closeAction->addTo(popup);
  connect(closeAction, SIGNAL(activated()), this, SLOT(slotClose()));

  smallAction = new QAction(this, "small");
  smallAction->setText(i18n ("Only") + " " + i18n("Link") );
  smallAction->setIconSet(QPixmap(*(options->getKwcDir()) + "small.png"));
 	smallAction->setToggleAction(true);
  smallAction->addTo(popup);
  connect(smallAction, SIGNAL(activated()), this, SLOT(slotSmall()));


  connect(options, SIGNAL(pollingChanged(int)), this, SLOT(slotPolling(int)));  

  connect(basicTimer, SIGNAL(timeout()), this, SLOT(slotAct()));
	connect(basicTimer, SIGNAL(timeout()), widget, SLOT(basicTimerSlot()));
  basicTimer->start(500, false);

	connect(shortTimer, SIGNAL(timeout()), widget, SLOT(shortTimerSlot()));
  

  state = 0;
  setState(state);

  smallWidget = new SmallWidget(options, 0, "SmallWidget", WStyle_NoBorder| WStyle_StaysOnTop|WX11BypassWM);
  smallWidget->hide();


}

KTray::~KTray()
{
	free(smallWidget);
}

/** No descriptions */
void KTray::setState(int value)
{
  state = value;
  setPixmap(icons[value]);
}

/** No descriptions */
void KTray::slotAct()
{
	link = -1;

  if( card->isWave() )
  {
    card->getLinkQual(link, avg, signal, noise);

    if(link < 0)
      link = 0;
    if(link > 100)
      link =100;
    
    QToolTip::add(this, QString::number(link) + '%');
  
    int newState = link / 10;
    if( (link < 10) && (link > 0) )
      newState = 1;
    if( link >= 100 )
      newState = 9;
    if( link == 0 )
    	newState = 10;
  
    if( newState != state )
    {
      setState(newState);
      state = newState;
    }

    
  }else{
    QToolTip::add(this, *options->getNotString());
    setState(10);
  }
  

  if(smallWidget->isVisible())
 	{
		smallWidget->act(link);
		smallAction->setOn(true);
	}
	else
	{
		smallAction->setOn(false);
	}    
}

void KTray::slotOpen()
{
  widget->show();
  widget->setFocus();
  shortTimer->start(1, false);  
}
void KTray::slotClose()
{
  widget->hide();
  shortTimer->stop();
}

/** No descriptions */
void KTray::mousePressEvent ( QMouseEvent *ev )
{
  if( ev->button() == LeftButton )
  {
    if(widget->isVisible())
    {
      slotClose();      
    }else{
      QPoint p;
      p.setX(ev->globalX() - (widget->width() / 2) );
      p.setY(ev->globalY() - (widget->height() + 50) );
      widget->move(p);
      slotOpen();
    }
  }
  
  if( ev->button() == RightButton )
    popup->exec(ev->globalPos());    
}

/** No descriptions */
void KTray::slotPolling(int value)
{
  basicTimer->stop();
  basicTimer->start(value*100, false);
}

/** No descriptions */
void KTray::slotSmall()
{
	if(smallWidget->isVisible())
	{
		smallWidget->hide();
	}
	else
	{
		smallWidget->show();
	}
}
