/***************************************************************************
                          fileplugin.h  -  description
                             -------------------
    begin                : Mon Jul 1 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEPLUGIN_H
#define FILEPLUGIN_H

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"
#include <kmimetype.h>

/*
 * number of items we shall cache from file plugins
 */
#define CACHE_MAX 2000

class KFileMetaInfoProvider;
class KFileMimeTypeInfo;
class KPushButton;
class KService;
class QLabel;
class QWidget;
class QVBoxLayout;
class KFilePlugin;
class FilePlugin : public Plugin  {
    Q_OBJECT
    public:
        FilePlugin( KService* service );
        ~FilePlugin();

        bool isValid() const {
            return keys.count() > 0 && fileplugin ? true : false;
        };

        virtual const QString getName() const;
        virtual const QString getAccelName() const;
        virtual const QString getPattern() const;
        virtual const int type() const;

        virtual bool checkError();
        virtual void drawInterface( QWidget* w, QVBoxLayout* l );
        virtual QString processFile( BatchRenamer* b, int i, QString token, int mode );

        virtual void addHelp( HelpDialogData* data );
        virtual const QPixmap getIcon() const;
        
        virtual bool alwaysUsed() const { return true; }
        
        virtual const QStringList getKeys() const { return keys; }

        virtual void clearCache();
        
    private:
        void setPattern( KMimeType::Ptr mime );
        
    protected:
        bool supports( const QString & token );
        void setupKeys();
        
        QMap<QString,QString> cache;
        KFilePlugin* fileplugin;

        QString m_name, m_comment, m_icon, m_mimetype, m_pattern;

        QStringList keys;
};
#endif
