/***************************************************************************
                  encodingplugin.cpp  -  description
                             -------------------
    begin                : Tue Jul 06 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "encodingplugin.h"

// QT includes
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtextcodec.h>
#include <qvgroupbox.h>


// KDE includes
#include <kapplication.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>

const QString EncodingPlugin::getName() const
{
    return i18n("Encoding Conversion Plugin");
}

const QString EncodingPlugin::getAccelName() const
{
    return i18n("&Encoding Conversion Plugin");
}

const int EncodingPlugin::type() const
{
    return TYPE_FINAL_FILENAME;
}

void EncodingPlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    // build a list of all available TextCodecs
    QStringList codecs;
    QTextCodec *codec;
    for( int i=0; (codec = QTextCodec::codecForIndex(i));i++)
        codecs.append( codec->name() );

    codec = QTextCodec::codecForLocale();
    m_locale_codec = codec->name();

    QLabel* label = new QLabel( 
	i18n("<qt>This plugin is able to convert filenames between different "
	     "encodings. For example you can convert filenames from KOI8-R "
	     "to UTF-8 encoding.</qt>"), w );
    l->addWidget( label );
    
    label = new QLabel( "<qt><b>WARNING! THIS PLUGIN IS UNTESTED AND MIGHT CAUSE LOSS OF DATA!</b></qt>", w );
    l->addWidget( label );
    
    QVGroupBox* groupInput = new QVGroupBox( i18n("Encoding of Input Files:"), w );
    checkInput = new QCheckBox( i18n("&Use local encoding: %1").arg( m_locale_codec), groupInput );
    comboInput = new KComboBox( false, groupInput );
    comboInput->insertStringList( codecs );

    QVGroupBox* groupOutput = new QVGroupBox( i18n("Encoding of Output Files:"), w );
    checkOutput = new QCheckBox( i18n("&Use local encoding: %1").arg( m_locale_codec), groupOutput );
    checkOutput->setChecked( true );
    comboOutput = new KComboBox( false, groupOutput );
    comboOutput->insertStringList( codecs );

    l->addWidget( groupInput );
    l->addWidget( groupOutput );

    connect( checkInput, SIGNAL( clicked() ), this, SLOT( enableControls() ) );
    connect( checkOutput, SIGNAL( clicked() ), this, SLOT( enableControls() ) );

    setLocale( comboInput );
    setLocale( comboOutput );

    enableControls();
}

void EncodingPlugin::fillStructure()
{
    m_input_codec = (checkInput->isChecked() ? m_locale_codec : comboInput->currentText() );
    m_output_codec = (checkOutput->isChecked() ? m_locale_codec : comboOutput->currentText() );
} 

bool EncodingPlugin::checkError()
{
   return true;
}

QString EncodingPlugin::processFile( BatchRenamer* b, int i, QString token, int )
{
    // token is the filename!
    QCString input =  token.latin1(); // not sure wether latin1() is correct in this case!
    QString unicode = QString::null;
    QCString output = 0;

    QTextCodec* toUnicode = QTextCodec::codecForName(m_input_codec); // get the codec for KOI8-R
    QTextCodec* fromUnicode = QTextCodec::codecForName(m_output_codec);

    unicode = toUnicode->toUnicode( input );
    output = fromUnicode->fromUnicode( unicode );

    /*
    KURL dest( output, fromUnicode->mibEnum() );
    KURL src = b->files()[i].dst.url;
    src.setPath( input );
    if( !fop.start( src, dest, RENAME, false ) )
	return fop.error(); // maybe called something other
    */
    return output; // no error
}

void EncodingPlugin::finished()
{
}


const QPixmap EncodingPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "fonts", KIcon::Small );
}

void EncodingPlugin::enableControls()
{
    comboInput->setEnabled( !checkInput->isChecked() );
    comboOutput->setEnabled( !checkOutput->isChecked() );
}

void EncodingPlugin::setLocale( KComboBox* combo )
{
    for(int i=0;i<combo->count();i++)
	if( combo->text(i) == m_locale_codec )
	{
	    combo->setCurrentItem( i );
	    break;
	}
}
