/***************************************************************************
                          confdialog.h  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFDIALOG_H
#define CONFDIALOG_H

// QT includes
#include <qcheckbox.h>

// KDE includes
#include <kdialogbase.h>
#include <knuminput.h>

#include "guimodeselector.h"

class QHBoxLayout;
class QVBoxLayout;
class QWidget;
class KIntNumInput;
class ConfDialog : public KDialogBase, public GUIModeSelector {
    Q_OBJECT
    public:
        ConfDialog( QWidget* parent = 0, const char* name = 0 );
        ~ConfDialog();

        bool loadplugins() const { return checkPlugins->isChecked(); }
        int thumbSize() const { return spinSize->value(); }
        bool autosize() const { return checkAutosize->isChecked(); }
        int historyItems() const { return spinHistory->value(); }

        void setLoadPlugins( bool b ) { checkPlugins->setChecked( b ); }
        void setThumbSize( int b ) { spinSize->setValue( b ); }
        void setAutosize( bool b ) { checkAutosize->setChecked( b ); }
        void setHistoryItems( int b ) { spinHistory->setValue( b ); }
        
    private slots:
        void defaults();

    private:
        void setupTab1();
        void setupTab2();
        
    protected:
        QCheckBox* checkAsk;
        QCheckBox* checkPlugins;
        QCheckBox* checkAutosize;

        KIntNumInput* spinSize;
        KIntNumInput* spinHistory;
};

#endif
