/*******************************************************************************
**                               backup.h
**                konserve -- A small backup application
**                         -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef BACKUP_H
#define BACKUP_H

// Qt includesQ
#include <qstring.h>
#include <qobject.h>

// KDE includes
#include <kurl.h>
#include <kio/job.h>
#include <kfileitem.h>

// Declarations
class KArchive;

////////////////////////////////////////////////////////////////////////////////
///////                  class Backup                                    ///////
////////////////////////////////////////////////////////////////////////////////

class Backup: public QObject
{
    Q_OBJECT

public:

    Backup( KURL surl, KURL aurl, bool readonly = false );
    ~Backup();

    void setSourceUrl( KURL url ) { mSourceUrl = url; }
    KURL getSourceUrl() const     { return mSourceUrl; }

    void setArchiveUrl( KURL url ) { mArchiveUrl = url; }
    KURL getArchiveUrl() const     { return mArchiveUrl; }

    void doBackup();
    void copyArchive();

signals:
    void finishedBackup( bool successful );

protected slots:
    void slotStartListing( KIO::Job* aJob );
    void slotGetEntriesAndPackEm( KIO::Job*, const KIO::UDSEntryList& list );
    void slotFinishedPacking( KIO::Job* aJob );
    void slotFinished( KIO::Job* aJob );

private:
    Backup( const Backup& b, bool readonly = true );
    KURL defaultArchiveName( KURL source, KURL archive );
    KURL dotCheck( KURL name );
    void writeToArchive( KFileItem f, bool usetext = false );

private:
    KURL                mSourceUrl;
    KURL                mTmpSourceUrl;
    KURL                mArchiveUrl;
    KURL                mTmpArchiveUrl;
    bool                mbReadOnly;
    KArchive           *mpArchive;
};

#endif
