/**********************************************************************/
/* DIALOGUE.C : Construction des boites de dialogue pour JERED        */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include "jered.h"
#include "formulr.h"
#include "messages.h"

static FORMLISTE fliste;        /* liste des formulaires de ce programme */

PTFORMU fcherche;        /* formulaire 1 */
static PTFZONE zfcherche[4];    /* zones du formulaire fcherche (1) */
static PTFTEXT tfcherche[4];    /* textes du formulaire fcherche (1) */

char vachercher[42];             /* pour la zone 1 de fcherche (1) */
char vremplacer[42];             /* pour la zone 2 de fcherche (1) */
char vignorer[2];                /* pour la zone 3 de fcherche (1) */

PTFORMU fcmdline;
static PTFZONE zfcmdline[2];

char vcmdline[66];      /* ligne de commande */

PTFORMU formmacro;
static PTFZONE zformmacro[2];

char vmacroname[66];    /* nom de la macro */

/**********************************************************************/
void delete_forms(void)
{
        free_allocated_fliste(&fliste);
}
/**********************************************************************/
int create_forms(void)
{
        int i;          /* compteur */
        chtype cf;
        chtype cn;

        /* indique que la liste est vide */
        fliste.ffirst = NULL;

        /* Creation du formulaire fcherche (1) */
        fcherche = cree_formulaire_vide(&fliste);
        if (fcherche == NULL)
                return(-1);
        fcherche->ftitre = message[MSG_FIND_REPLACE];

        /* Creation des textes du formulaire fcherche (1) */
        for (i = 0; i < 3; i++)
        {
                tfcherche[i] = cree_texte_vide(fcherche);
                if (tfcherche[i] == NULL)
                        return(-1);
        }

        /* Initialisation des textes du formulaire fcherche (1) */
        tfcherche[0]->xr = 2;
        tfcherche[0]->yr = 2;
        tfcherche[0]->texte = message[MSG_FIND];

        tfcherche[1]->xr = 2;
        tfcherche[1]->yr = 4;
        tfcherche[1]->texte = message[MSG_REPLACEWITH];

        tfcherche[2]->xr = 2;
        tfcherche[2]->yr = 6;
        tfcherche[2]->texte = message[MSG_IGNORECASE];
        
        /* Creation des zones du formulaire fcherche (1) */
        for (i = 0; i < 3; i++)
        {
                zfcherche[i] = cree_zone_vide(fcherche);
                if (zfcherche[i] == NULL)
                        return(-1);
        }

        /* Initialisation des zones du formulaire fcherche (1) */
        zfcherche[0]->xr = 18;
        zfcherche[0]->yr = 2;
        zfcherche[0]->force = FORCESAISIE;
        zfcherche[0]->variable = vachercher;
        zfcherche[0]->format = "ssssssssssssssssssssssssssssssssssssssss";
        zfcherche[0]->fill   = "                                        ";
        zfcherche[0]->aidenlig = message[MSG_FINDHELP];

        zfcherche[1]->xr = 18;
        zfcherche[1]->yr = 4;
        zfcherche[1]->variable = vremplacer;
        zfcherche[1]->format = "ssssssssssssssssssssssssssssssssssssssss";
        zfcherche[1]->fill   = "                                        ";
        zfcherche[1]->aidenlig = message[MSG_REPLACEHELP];

        zfcherche[2]->xr = 18;
        zfcherche[2]->yr = 6;
        zfcherche[2]->force = FORCESAISIE;
        zfcherche[2]->variable = vignorer;
        zfcherche[2]->format = "Y";
        zfcherche[2]->fill   = " ";
        zfcherche[2]->aidenlig = message[MSG_IGNOREHELP];

        fcmdline = cree_formulaire_vide(&fliste);
        if (fcmdline == NULL)
                return(-1);
        fcmdline->ftitre = message[MSG_RUN];

        for (i = 0; i < 1; i++)
        {
                zfcmdline[i] = cree_zone_vide(fcmdline);
                if (zfcmdline[i] == NULL)
                        return(-1);
        }

        zfcmdline[0]->xr = 2;
        zfcmdline[0]->yr = 1;
        zfcmdline[0]->variable = vcmdline;
        zfcmdline[0]->format = "ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss";
        zfcmdline[0]->fill   = "                                                                ";
        zfcmdline[0]->aidenlig = message[MSG_TYPE_COMMAND];

        formmacro = cree_formulaire_vide(&fliste);
        if (formmacro == NULL)
                return(-1);
        formmacro->ftitre = message[MSG_SAVE_MACRO];

        for (i = 0; i < 1; i++)
        {
                zformmacro[i] = cree_zone_vide(formmacro);
                if (zformmacro[i] == NULL)
                        return(-1);
        }

        zformmacro[0]->xr = 2;
        zformmacro[0]->yr = 1;
        zformmacro[0]->variable = vmacroname;
        zformmacro[0]->format = "ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss";
        zformmacro[0]->fill   = "                                                                ";
        zformmacro[0]->aidenlig = message[MSG_TYPE_MACRONAME];

        cf = couleur[COULEUR_ALERTE1];
        cn = couleur[COULEUR_NORMALE];
        init_application_fliste(&fliste, NULL, SIMPLECADRE, MODEROULEAU, cf, cf, cf, cf, cn, cn, couleur[COULEUR_ALERTE2]);

        return(0);
}
/**********************************************************************/
