/***************************************************************************
                          ball.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ball.h"

class Point2D;

int udt, udb, udl, udr;

void update_dirty(int ludl, int ludr, int ludt, int ludb)
{
	if(ludl > ludr)
	{
		int temp = ludl;
		ludl = ludr; ludr = temp;
	}
	if(ludt > ludb)
	{
		int temp = ludt;
		ludt = ludb; ludb = temp;
	}
	if(udl == -1)
	{
		udl = ludl; udr = ludr;
		udt = ludt; udb = ludb;
	}
	else
	{
		if(ludl < udl) udl = ludl;
		if(ludr > udr) udr = ludr;
		if(ludt < udt) udt = ludt;
		if(ludb > udb) udb = ludb;
	}
}

Ball::Ball(void){
	vel.dx = 0;
	vel.dy = 0;
	radius = diam = 0;
}

Ball::Ball (double x, double y, int d, GdkColor *c, int cat = other, bool isq = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false) : Point2D(x, y), vel(0, 0), bnc(0, 0), tvec(0, 0) {
	radius = (diam = d) / 2;
	clr = c;
	is_cue = isq; is_eight = ise; is_nine = isn;
	is_solid = isso; is_stripe = isst;
	category = cat;
	picture = (GdkPixmap *)NULL;
	ball_num = 15;
}

Ball::Ball (double x, double y, int d, int bn, GdkPixmap *pixmap, GdkBitmap *c_bmp, GdkPixmap *b_pixmap, GdkBitmap *b_clip_bmp, int cat = other, bool isq = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false) : Point2D(x, y), vel(0, 0), bnc(0, 0), tvec(0, 0) {
	radius = (diam = d) / 2;
	clr = (GdkColor *)NULL;
	is_cue = isq; is_eight = ise; is_nine = isn;
	is_solid = isso; is_stripe = isst;
	category = cat;
	picture = pixmap;
	clip_bmp = c_bmp;
	big_picture = b_pixmap;
	big_clip_bmp = b_clip_bmp;
	ball_num = bn;
}

bool Ball::moving () {
	if (vel.dx != 0  ||  vel.dy != 0)
		return true;
	else
		return false;
}

void Ball::decel (double val) {
	if (val >= vel.mag())
		vel.setVec(0, 0);
	else
		vel.subVec(tvec.setVec(vel).unitVec().mulVec(val));
}

double Ball::pathIntercept (Ball b) {
	double d = radius + b.radius;
	double ddx = vel.dx - b.vel.dx;
	double ddy = vel.dy - b.vel.dy;
	double dx = x - b.x;
	double dy = y - b.y;
	double A = ddx * ddx + ddy * ddy;
	double B = 2 * (dx * ddx + dy * ddy);
	double C = dx * dx + dy * dy - d * d;
	return (-B - sqrt(B * B - 4 * A * C)) / (2 * A);
}

void Ball::collide (Ball *b, double COLLIDE_DRAG = 0.7) {
	// Calculate collision in b's reference frame
	Vec2D v12(*this, *b); v12.unitVec();
	Vec2D v21(v12);
	double mag1 = vel.mag(), mag2 = b->vel.mag();
	double cos1 = vel.dotProd(v12), cos2 = b->vel.dotProd(v21);
	double rot = 1.0 - COLLIDE_DRAG, pow = 1.0 - rot;
		
	// the following two code lines assume a maximum vel of 40.
	// generally it should be 0.7 + 0.3 *mag/velmax
	// traveled distance prior to impact should be accounted for, e.g.:
	// 0.7 + 0.3 *(mag/velmax * distmax/dist)
	v12.mulVec((pow + (rot * (mag1/40)))*cos1-0.7*cos2);
	v21.mulVec((pow + (rot * (mag2/40)))*cos2-0.7*cos1);
	
	vel.subVec(v12);
	b->vel.subVec(v21);
}

double Ball::edgeIntercept (GdkRectangle table) {
	if (vel.dx >= 0)
		hCol = (table.width + table.x - x - radius) / vel.dx;
	else
		hCol = (table.x - x + radius) / vel.dx;
	if (vel.dy >= 0)
		vCol = (table.height + table.y - y - radius) / vel.dy;
	else
		vCol = (table.y - y + radius) / vel.dy;
	if(vel.dx == 0)
		return vCol;
	if(vel.dy == 0)
		return hCol;
	return hCol <= vCol ? hCol : vCol;
}

void Ball::bounce (double t, double BUMPER_DRAG = 0.8) {
	if (t == hCol)
		vel.dx = -vel.dx;
	if (t == vCol)
		vel.dy = -vel.dy;
	vel.dx *= BUMPER_DRAG; vel.dy *= BUMPER_DRAG;
}

void Ball::move (double t) {
	if (moving())
	{
		// move the ball, then update the dirty rectangle
		int oldx = int(x), oldy = int(y);
		int newx, newy;
//		int newx, newy, ludl, ludr, ludt, ludb;
		addPos(vel.copy().mulVec(t));
		newx = int(x); newy = int(y);
		if(newx != oldx || newy != oldy) // ie, ball has moved perceptibly
		{
			udl = 0; udr = 780;
			udt = 0; udb = 420;
			//update_dirty(udl, udr, udt, udb);
		}
	}
}

void Ball::draw (GdkDrawable *pixmap, GdkGC *gc) const {
		if(picture)
		{
			gdk_gc_set_clip_mask(gc, clip_bmp);
			gdk_gc_set_clip_origin(gc, int(x - diam / 2), int(y - diam / 2));
			gdk_draw_pixmap(pixmap, gc, picture, 0, 0, int(x - diam / 2),
			                int (y - diam / 2), BALL_SIZE, BALL_SIZE);
			gdk_gc_set_clip_origin(gc, 0, 0);
			gdk_gc_set_clip_mask(gc, (GdkWindow *)NULL);
		}
		else
		{
			gdk_gc_set_foreground(gc, clr);
			gdk_gc_set_background(gc, clr);
			gdk_draw_arc(pixmap, gc, 1, int(x - radius), int(y - radius),
			             diam, diam, 0, 360 * 64);
		}
}

void Ball::shoot (Point2D ptr) {
	vel.setVec((x - ptr.x) / 5, (y - ptr.y) / 5);
}

bool Ball::touches (double mx, double my) {
	return Point2D(mx, my).dist(*this) < radius;
}

Ball::~Ball(){
}
