/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"
#include "gnome-cmd-prepare-move-dialog.h"
#include "gnome-cmd-prepare-xfer-dialog.h"
#include "gnome-cmd-dir-funcs.h"
#include "dir_pool.h"
#include "gnome-cmd-xfer.h"
#include "gnome-cmd-connection-funcs.h"
#include "gnome-cmd-dir-funcs.h"
#include "gnome-cmd-file-funcs.h"
#include "gnome-cmd-file-selector-funcs.h"
#include "gnome-cmd-main-win-funcs.h"


typedef struct
{
	GnomeCmdPrepareXferDialog *dialog;
	GtkWidget *silent;
	GtkWidget *query;
	GtkWidget *skip;
	
} PrepareMoveData;


static void
on_ok (GtkButton *button, gpointer user_data)
{
	PrepareMoveData *data = (PrepareMoveData*)user_data;
	GnomeCmdPrepareXferDialog *dlg = data->dialog;

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->silent)))
		dlg->xferOverwriteMode = GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE;
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->query)))
		dlg->xferOverwriteMode = GNOME_VFS_XFER_OVERWRITE_MODE_QUERY;
	else
		dlg->xferOverwriteMode = GNOME_VFS_XFER_OVERWRITE_MODE_SKIP;

	dlg->xferOptions = GNOME_VFS_XFER_REMOVESOURCE;
}


void
gnome_cmd_prepare_move_dialog_show (GnomeCmdFileList *from,
									GnomeCmdFileSelector *to)
{
	GSList *group = NULL;
	PrepareMoveData *data = g_new (PrepareMoveData, 1);
	GnomeCmdFile *finfo;
	gint num_files;
	gchar *dest_dir_frame_msg;
	GList *tmp;
	
	tmp = gnome_cmd_file_list_get_selected_files (from);
	if (!tmp) {
		g_list_free (tmp);
		return;
	}
	
	data->dialog = GNOME_CMD_PREPARE_XFER_DIALOG (gnome_cmd_prepare_xfer_dialog_new (
		from, to));
	gtk_window_set_title (GTK_WINDOW (data->dialog), _("Move"));
	gtk_widget_ref (GTK_WIDGET (data->dialog));
	

	/*
	 * Create prepare copy specific widgets
	 */
	data->silent = gtk_radio_button_new_with_label (group, _("Silently"));
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (data->silent));
	gtk_widget_ref (data->silent);
	gtk_object_set_data_full (GTK_OBJECT (data->dialog), "silent", data->silent,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (data->silent);
	gtk_box_pack_start (GTK_BOX (data->dialog->left_vbox), data->silent, FALSE, FALSE, 0);

	
	data->query = gtk_radio_button_new_with_label (group, _("Query First"));
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (data->query));
	gtk_widget_ref (data->query);
	gtk_object_set_data_full (GTK_OBJECT (data->dialog), "query", data->query,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (data->query);
	gtk_box_pack_start (GTK_BOX (data->dialog->left_vbox), data->query, FALSE, FALSE, 0);

	
	data->skip = gtk_radio_button_new_with_label (group, _("Skip All"));
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (data->skip));
	gtk_widget_ref (data->skip);
	gtk_object_set_data_full (GTK_OBJECT (data->dialog), "skip", data->skip,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (data->skip);
	gtk_box_pack_start (GTK_BOX (data->dialog->left_vbox), data->skip, FALSE, FALSE, 0);

	
	// Set query as default, this options should really be saved as a config options
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->query), TRUE);

	/*
	 * Customize prepare xfer widgets 
	 */
	gtk_frame_set_label (GTK_FRAME (data->dialog->left_vbox_frame),
						 _("Overwrite Files"));
	
	gtk_frame_set_label (GTK_FRAME (data->dialog->right_vbox_frame),
						 _("Options"));

	num_files = g_list_length (data->dialog->src_files);
	finfo = (GnomeCmdFile*)data->dialog->src_files->data;
	
	if (num_files == 1)
		dest_dir_frame_msg = g_strdup_printf (_("Move \"%s\" to"), finfo->info->name);
	else
		dest_dir_frame_msg = g_strdup_printf (ngettext("move %d file to","move %d files to",num_files), num_files);
	
	gtk_frame_set_label (GTK_FRAME (data->dialog->dest_dir_frame),
						 dest_dir_frame_msg);

	g_free  (dest_dir_frame_msg);


	
	/*
	 * Connect signals
	 */
	gtk_signal_connect (GTK_OBJECT (data->dialog->ok_button), "clicked", on_ok, data);

	
	/*
	 * Show the dialog
	 */	
	gtk_widget_show (GTK_WIDGET (data->dialog));
}
