/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_FILE_SELECTOR_TYPES_H__
#define __GNOME_CMD_FILE_SELECTOR_TYPES_H__

#include "gnome-cmd-file-list.h"


BEGIN_GNOME_DECLS

#define GNOME_CMD_FILE_SELECTOR(obj) \
	GTK_CHECK_CAST (obj, gnome_cmd_file_selector_get_type (), GnomeCmdFileSelector)
#define GNOME_CMD_FILE_SELECTOR_CLASS(klass) \
	GTK_CHECK_CLASS_CAST (klass, gnome_cmd_file_selector_get_type (), GnomeCmdFileSelectorClass)
#define GNOME_CMD_IS_FILE_SELECTOR(obj) \
	GTK_CHECK_TYPE (obj, gnome_cmd_file_selector_get_type ())

#define DIR_HISTORY_SIZE 20

typedef struct _GnomeCmdFileSelector GnomeCmdFileSelector;
typedef struct _GnomeCmdFileSelectorPrivate GnomeCmdFileSelectorPrivate;
typedef struct _GnomeCmdFileSelectorClass GnomeCmdFileSelectorClass;


struct _GnomeCmdFileSelector
{
	GtkVBox vbox;

	GtkWidget *con_hbox;
	GtkWidget *dir_hbox;
	GtkWidget *root_btn;
	GtkWidget *parent_btn;
	GtkWidget *dir_combo;
	GtkWidget *scrolledwindow;
	GtkWidget *info_label;
	GtkWidget *list_widget;
	GnomeCmdFileList *list;
	GtkWidget *con_combo;
	GtkWidget *vol_label;
	
	GnomeCmdFileSelectorPrivate *priv;
};


struct _GnomeCmdFileSelectorClass
{
	GtkVBoxClass parent_class;

	void (* changed_dir)       (GnomeCmdFileSelector *fs,
								GnomeCmdDir *dir);
};

#endif //__GNOME_CMD_FILE_SELECTOR_TYPES_H__
