"""Python Bindings for DiaCanvas2.

This file provides an alternative way for building the Python bindings of
DiaCanvas2. 
TODO: Write a good long description"""

MAJOR_VERSION = 0
MINOR_VERSION = 12
MICRO_VERSION = 0

from distutils.command.build import build
from distutils.core import setup
import os
import sys

try:
    import pygtk
    pygtk.require('2.0')
except (ImportError, AssertionError):
    raise SystemExit, 'ERROR: Could not find a recent version of pygtk.'

try:
    import gnome.canvas
except (ImportError, AssertionError):
    raise SystemExit, 'ERROR: Could not find a GnomeCanvas Python binding'

from dsextras import list_files, have_pkgconfig, GLOBAL_INC, GLOBAL_MACROS
from dsextras import InstallLib, BuildExt, PkgConfigExtension
from dsextras import Template, TemplateExtension, pkgc_version_check
from dsextras import getoutput

GLOBAL_MACROS += [('DIACANVAS_MAJOR_VERSION', MAJOR_VERSION)]
GLOBAL_MACROS += [('DIACANVAS_MINOR_VERSION', MINOR_VERSION)]
GLOBAL_MACROS += [('DIACANVAS_MICRO_VERSION', MICRO_VERSION)]

VERSION = "%d.%d.%d" % (MAJOR_VERSION,
                        MINOR_VERSION,
                        MICRO_VERSION)

PYGTK_REQUIRED_VERSION              = '2.0.0'
LIBGNOMECANVAS_REQUIRED_VERSION     = '2.0.0'
LIBDIACANVAS2_REQUIRED_VERSION      = '0.9.2'

PYGTK_SUFFIX = '2.0'
PYGTK_SUFFIX_LONG = 'gtk-' + PYGTK_SUFFIX

GLOBAL_INC.append('..')

DEFS_DIR    = os.path.join('share', 'pygtk', PYGTK_SUFFIX, 'defs')
CODEGEN_DIR = os.path.join('share', 'pygtk', PYGTK_SUFFIX, 'codegen')
INCLUDE_DIR = os.path.join('include', 'pygtk-%s' % PYGTK_SUFFIX)

str_version = sys.version[:3]
version = map(int, str_version.split('.'))
if version < [2, 2]:
    raise SystemExit, \
          "Python 2.2 or higher is required, %s found" % str_version

if not pkgc_version_check('pygtk-2.0', 'PyGTK', PYGTK_REQUIRED_VERSION):
    raise SystemExit, "Aborting"
pygtkincludedir = getoutput('pkg-config --variable pygtkincludedir pygtk-2.0')
codegendir = getoutput('pkg-config --variable codegendir pygtk-2.0')
defsdir = getoutput('pkg-config --variable defsdir pygtk-2.0')

GLOBAL_INC.append(pygtkincludedir)
GTKDEFS = [os.path.join(defsdir, 'pango-types.defs'),
           os.path.join(defsdir, 'gdk-types.defs'),
           os.path.join(defsdir, 'gtk-types.defs')]
CANVASDEFS = [os.path.join(defsdir, 'canvas.defs')]

sys.path.append(codegendir)
try:
    from override import Overrides
except ImportError:
    raise SystemExit, \
'Could not find code generator in %s, do you have installed pygtk correctly?'

canvas = TemplateExtension(name = 'diacanvas',
                           pkc_name='diacanvas2',
                           pkc_version=LIBDIACANVAS2_REQUIRED_VERSION,
                           output='diacanvas._canvas',
                           defs='diacanvas.defs',
                           sources=['diacanvas.c',
                                    'pydiacanvasitem.c',
                                    'diacanvasmodule.c'],
                           register=GTKDEFS + CANVASDEFS + \
                           ['../diacanvas/dia-boxed.defs', 'diashape.defs'],
                           override='diacanvas.override',
                           )
                               
view = TemplateExtension(name = 'diaview',
                         pkc_name='diacanvas2',
                         pkc_version=LIBDIACANVAS2_REQUIRED_VERSION,
                         output='diacanvas.view',
                         defs='diaview.defs',
                         sources=['diaview.c',
                                  'diaviewmodule.c'],
                         register=GTKDEFS + ['diacanvas.defs'],
                         override='diaview.override',
                         )
                               
geometry = TemplateExtension(name = 'diageometry',
                             pkc_name='diacanvas2',
                             pkc_version=LIBDIACANVAS2_REQUIRED_VERSION,
                             output='diacanvas.geometry',
                             defs='diageometry.defs',
                             sources=['diageometry.c',
                                      'diageometrymodule.c'],
                             register=['diacanvas.defs'],
                             override='diageometry.override',
                             )

shape = TemplateExtension(name = 'diashape',
                          pkc_name='diacanvas2',
                          pkc_version=LIBDIACANVAS2_REQUIRED_VERSION,
                          output='diacanvas.shape',
                          defs='diashape.defs',
                          sources=['diashape.c',
                                   'diashapemodule.c'],
                          register=GTKDEFS + ['diacanvas.defs'],
                          override='diashape.override',
                          )

data_files = []
ext_modules = []
py_modules = []

if canvas.can_build():
    ext_modules.append(canvas)
    data_files.append((DEFS_DIR, ('diacanvas.defs',
                                  '../diacanvas/dia-boxed.defs')))

if view.can_build():
    ext_modules.append(view)
    data_files.append((DEFS_DIR, ('diaview.defs',)))
    
if geometry.can_build():
    ext_modules.append(geometry)
    data_files.append((DEFS_DIR, ('diageometry.defs',)))
    
if shape.can_build():
    ext_modules.append(shape)
    data_files.append((DEFS_DIR, ('diashape.defs',)))

if canvas.can_build() and view.can_build() and geometry.can_build() and shape.can_build():
    py_modules.append('diacanvas.__init__')
    py_modules.append('diacanvas.placementtool')
    
doclines = __doc__.split("\n")

setup(name="pydiacanvas2",
      url='http://diacanvas.sourceforge.net',
      version=VERSION,
      license='LGPL',
      platforms=['yes'],
      maintainer="Arjan Molenaar",
      maintainer_email="arjanmol@users.sourceforge.net",
      description = doclines[0],
      long_description = '\n'.join(doclines[2:]),
      package_dir={ 'diacanvas': '.',
                    'diacanvas.__init__': '.',
                    'diacanvas.placementtool': '.' },
      py_modules=py_modules,
      ext_modules=ext_modules,
      data_files=data_files,
      cmdclass={'build_ext': BuildExt})
