/* dia-stack-tool.c
 * Copyright (C) 2001  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "dia-stack-tool.h"
#include "dia-canvas-i18n.h"

#include "dia-handle-layer.h"
#include <gobject/gvaluecollector.h>

/* We need them to determine which handle we should grab: */
#include "dia-canvas-line.h"
#include "dia-canvas-element.h"

static void dia_stack_tool_class_init	(DiaToolClass *class);
static void dia_stack_tool_init		(DiaStackTool *tool);
static void dia_stack_tool_dispose		(GObject *object);

static gboolean dia_stack_tool_button_press	(DiaTool *tool,
						 DiaCanvasView *view,
						 GdkEventButton *event);
static gboolean dia_stack_tool_button_release (DiaTool *tool,
						 DiaCanvasView *view,
						 GdkEventButton *event);
static gboolean dia_stack_tool_motion_notify (DiaTool *tool,
						 DiaCanvasView *view,
						 GdkEventMotion *event);
static gboolean dia_stack_tool_key_press	(DiaTool *tool,
						 DiaCanvasView *view,
						 GdkEventKey *event);
static gboolean dia_stack_tool_key_release	(DiaTool *tool,
						 DiaCanvasView *view,
						 GdkEventKey *event);

static DiaToolClass *parent_class = NULL;

GType
dia_stack_tool_get_type (void)
{
	static GtkType object_type = 0;

	if (!object_type) {
		static const GTypeInfo object_info = {
			sizeof (DiaStackToolClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) dia_stack_tool_class_init,
			(GClassFinalizeFunc) NULL,
			(gconstpointer) NULL, /* class_data */
			sizeof (DiaStackTool),
			(guint16) 0, /* n_preallocs */
			(GInstanceInitFunc) dia_stack_tool_init,
		};

		object_type = g_type_register_static (DIA_TYPE_TOOL,
						      "DiaStackTool",
						      &object_info, 0);
	}

	return object_type;
}

static void
dia_stack_tool_class_init (DiaToolClass *klass)
{
	GObjectClass *object_class = (GObjectClass*) klass;

	parent_class = g_type_class_peek_parent (klass);

	object_class->dispose = dia_stack_tool_dispose;
	klass->button_press_event = dia_stack_tool_button_press;
	klass->button_release_event = dia_stack_tool_button_release;
	klass->motion_notify_event = dia_stack_tool_motion_notify;
	klass->key_press_event = dia_stack_tool_key_press;
	klass->key_release_event = dia_stack_tool_key_release;
}

static void
dia_stack_tool_init (DiaStackTool *tool)
{
	tool->stack = NULL;
}

static void
dia_stack_tool_dispose (GObject *object)
{
	DiaStackTool *tool = (DiaStackTool*) object;

	g_message (__FUNCTION__);
	if (tool->stack) {
		GList *l;
		for (l = tool->stack; l != NULL; l = l->next)
			g_object_unref (l->data);
		g_list_free (tool->stack);
		tool->stack = NULL;
	}

	G_OBJECT_CLASS (parent_class)->dispose (object);
}

static gboolean
dia_stack_tool_button_press (DiaTool *tool, DiaCanvasView *view,
			         GdkEventButton *event)
{
	DiaStackTool *stack_tool = (DiaStackTool*) tool;

	if (stack_tool->stack)
		return dia_tool_button_press (DIA_TOOL (stack_tool->stack->data),
					      view, event);
	return FALSE;
}

static gboolean
dia_stack_tool_button_release (DiaTool *tool, DiaCanvasView *view,
				   GdkEventButton *event)
{
	DiaStackTool *stack_tool = (DiaStackTool*) tool;

	if (stack_tool->stack)
		return dia_tool_button_release (DIA_TOOL (stack_tool->stack->data),
					        view, event);
	return FALSE;
}

static gboolean
dia_stack_tool_motion_notify (DiaTool *tool, DiaCanvasView *view,
			      GdkEventMotion *event)
{
	DiaStackTool *stack_tool = (DiaStackTool*) tool;

	if (stack_tool->stack)
		return dia_tool_motion_notify (DIA_TOOL (stack_tool->stack->data),
					   view, event);
	return FALSE;
}

static gboolean
dia_stack_tool_key_press (DiaTool *tool, DiaCanvasView *view,
			      GdkEventKey *event)
{
	DiaStackTool *stack_tool = (DiaStackTool*) tool;

	if (stack_tool->stack)
		return dia_tool_key_press (DIA_TOOL (stack_tool->stack->data),
					   view, event);
	return FALSE;
}

static gboolean
dia_stack_tool_key_release (DiaTool *tool, DiaCanvasView *view,
			    GdkEventKey *event)
{
	DiaStackTool *stack_tool = (DiaStackTool*) tool;

	if (stack_tool->stack)
		return dia_tool_key_release (DIA_TOOL (stack_tool->stack->data),
					     view, event);
	return FALSE;
}

DiaTool*
dia_stack_tool_new (void)
{
	DiaStackTool *tool = g_object_new (DIA_TYPE_STACK_TOOL, NULL);

	return (DiaTool*) tool;
}

void
dia_stack_tool_push (DiaStackTool* stack_tool, DiaTool *tool)
{
	g_return_if_fail (DIA_IS_STACK_TOOL (stack_tool));
	g_return_if_fail (DIA_IS_TOOL (tool));

	g_object_ref (tool);
	stack_tool->stack = g_list_prepend (stack_tool->stack, tool);
}

void
dia_stack_tool_pop (DiaStackTool* stack_tool)
{
	g_return_if_fail (DIA_IS_STACK_TOOL (stack_tool));

	if (stack_tool->stack) {
		DiaTool *tool;

		tool = g_list_first (stack_tool->stack)->data;
		stack_tool->stack = g_list_remove (stack_tool->stack, tool);
		g_object_unref (tool);
	}
}

