#ifndef __parsetree_h__
#define __parsetree_h__


#ifndef __dictionary_h__
# include "dictionary.h"
#endif

#ifndef __tree_h__
# include "tree.h"
#endif

#include <stdio.h>


/** Token of this node. */
#define $token tree->data

/** Length of the right-hand-side of this production. */
#define $length tree->count

/** Lexeme associated with this terminal. */
#define $lexeme ((char*)(tree->children[0]->data))

/** Synthesised attribute of this node. */
#define $$(f) (f(tree,in))

/** Synthesised value of the nth child. */
#define $(child,f) (f(tree->children[child-1],in))

/** Calls the specified function for all children. */
#define $all(f) { int i; for( i = 1; i <= $length; i++) $(i,f); }

/** Returns the sum of all the synthesied values. */
#define $sum(f) ({ int i, sum = 0; for( i = 1; i <= $length; i++) \
	sum += $(i,f); sum; })

/** Returns the max of all the synthesied values. */
#define $max(f) ({ int i, best = 0; for( i = 1; i <= $length; i++) { \
	int tmp = $(i,f); if( tmp > best) best = tmp; } best; })

void destroy_parse_tree( Tree* tree);
void print_parse_tree( const Tree* tree, const Dictionary* symbols);
Tree* read_parse_tree( FILE* file, const Dictionary* symbols);
void print_lexemes( const Tree* tree);


/** Returns this token. */
static inline int
token( const Tree* tree, const void* in)
{
	(void)in;
	return tree->data;
}


/** Returns this lexeme. */
static inline const char*
lexeme( const Tree* tree, const void* in)
{
	(void)in;
	return (char*)tree->children[0]->data;
}


#endif
