#ifndef __string_h__
#define __string_h__


#include "dictionary.h"
#include "tree.h"
#include <stdio.h>


/** Token indicating the end of the string. */
#define END 0


/** String of symbols. */
typedef struct {
	/** Next symbol. */
	Tree* next;
	/** Second symbol. */
	Tree* second;
	/** Rest of the symbols. */
	FILE* file;
	/** Symbol table. */
	const Dictionary* symbols;
	/** Current line number. */
	int line;
	/** Current column number. */
	int column;
} String;


void set_string( String* w, FILE* file, const Dictionary* symbols);
int first( String* w);
Tree* next( String* w);
void push_symbol( String* w, Tree* a);


#endif
