#ifndef __regex_h__
#define __regex_h__


#include <limits.h>
#include <stdio.h>
#include "nfa.h"


/** Regular expression syntax tree. */
typedef struct RegEx {
	struct RegEx* left;
	struct RegEx* right;
	char data[CHAR_MAX];
} RegEx;


void print_range( const char* range);
void print_regex( const RegEx* regex);
void destroy_regex( RegEx* regex);
RegEx* parse_regex( FILE* file);
int compile_regex( NFA* nfa, const RegEx* regex, int token);


#endif
