#!/bin/sh
#
# Tries to create a package with another debian/.
#
#   Need dpatch package.
#     you have to modify dpatch-edit-patch
#        add 'debian/rules prepatch || true' after debian/rules clean 

set -e

if test "x$1" = "x"; then
  echo "Usage: $0 [<old.dsc>] <new.dsc>"
  exit 1
fi

if test -f "/usr/share/debnest/modules"; then
    . /usr/share/debnest/modules
fi

curdir=`pwd`

if test "x$2" != "x"; then
  olddsc=$1
  newdsc=$2
  if ! echo $olddsc | grep -q "^/"; then
    olddsc=$curdir/$olddsc
  fi
  TMPDIR=/tmp/`basename $0`.$$
  mkdir $TMPDIR
  trap "/bin/rm -rf $TMPDIR" 0


  oldsrc=`src $olddsc`
  veroldne=`version_noepoch $olddsc`
  upverold=`upstream_version $olddsc`

else
  newdsc=$1
fi

if ! echo $newdsc | grep -q "^/"; then
  newdsc=$curdir/$newdsc
fi

newsrc=`src $newdsc`
verne=`version_noepoch $newdsc`
upvernew=`upstream_version $newdsc`

EXTRA_BUILDDEP=" "
DEBNEST_RULES=/usr/share/doc/debnest/examples/rules-backport
export EXTRA_BUILDDEP DEBNEST_RULES

debnest_make $newdsc

(cd $newsrc-debian-$verne; make -f /usr/share/debnest/debnest.mk debnest-import; cp /usr/share/dpatch/dpatch.make debian/scripts/)

mkdir $newsrc-debian-$verne/debian/patches/
touch $newsrc-debian-$verne/debian/patches/00list

apply_olddebian() {
  /usr/share/debnest/dsc2debian $olddsc $newsrc-debian-$verne
  ( cd $newsrc-debian-$verne; debian/rules debnest-unpack; /bin/cp -a build-tree build-tree.orig )
  (cd $TMPDIR; dpkg-source -x $olddsc)
  /bin/cp -a $TMPDIR/$oldsrc-$upverold/debian $newsrc-debian-$verne/build-tree/$newsrc-$upvernew/

  cat > $newsrc-debian-$verne/debian/patches/00_backport.dpatch <<EOF
#! /bin/sh -e
## 00_backport.dpatch ${DEBFULLNAME} <${DEBEMAIL:-${EMAIL:-$LOGNAME@`hostname -f`}}>
##
## All lines beginning with \`## DP:' are a description of the patch.
## DP: Backport patch from $oldsrc $veroldne
                                                                                
if [ \$# -ne 1 ]; then
    echo "\`basename \$0\`: script expects -patch|-unpatch as argument" >&2
    exit 1
fi
case "\$1" in
    -patch) patch -f --no-backup-if-mismatch -p0 < \$0;;
    -unpatch) patch -f --no-backup-if-mismatch -R -p0 < \$0;;
    *)
        echo "\`basename \$0\`: script expects -patch|-unpatch as argument" >&2
        exit 1;;
esac
                                                                                
exit 0
                                                                                
EOF
  chmod 755 $newsrc-debian-$verne/debian/patches/00_backport.dpatch
  (cd $newsrc-debian-$verne; diff -urN --exclude=changelog build-tree.orig build-tree >> debian/patches/00_backport.dpatch || true; /bin/rm -rf build-tree.orig; fakeroot debian/rules clean)
  echo 00_backport > $newsrc-debian-$verne/debian/patches/00list
}

if test "x$olddsc" != "x"; then
  apply_olddebian
fi

