#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "AVLTree.h"
#include "symbol.h"

static AVLTree symbolset = {
	NULL,
	NULL,
	NULL,
	(AVLCompare)strcmp,
	(AVLFreeItem)free
};

int symcmp(symbol_t a, symbol_t b) {
	return a-b;
}

void symbol_dump(void) {
	AVLNode *c;
	for(c = symbolset.head; c; c = c->next)
		fprintf(stderr, "%s\n", (char *)c->item);
}

symbol_t symbol(const char *src) {
	AVLNode *node, *newnode;
	char *s;
	int r;

	if(!src)
		return errno = EINVAL, (symbol_t)NULL;

	r = AVLCloseSearch(&symbolset, src, &node);
	if(!r && node)
		return node->item;

	if((s = strdup(src))) {
		if((newnode = AVLInitNode(malloc(sizeof(AVLNode)), s))) {
			switch(r) {
				case -1:
					AVLInsertNodeBefore(&symbolset, node, newnode);
				break;
				case 0:
					AVLInsertTopNode(&symbolset, newnode);
				break;
				case 1:
					AVLInsertNodeAfter(&symbolset, node, newnode);
				break;
			}
			return s;
		}
		free(s);
	}
	return NULL;
}
