/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * main.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: main.h,v 1.3 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __MAIN_H__
#define __MAIN_H__

typedef enum
{
	DO_RECONNECT=0,
	DO_EXIT=1
} HUBDISC_FLAG;

/*****************************/
/* display connection status */
/*****************************/
void display_cnx_status(void);

/**************************************************************/
/* this function is called when the hub closes its connection */
/*********************************************************************************/
/* if exit_flag==DO_EXIT, the client will not attempt to automatically reconnect */
/*********************************************************************************/
void hub_disconnect(HUBDISC_FLAG exit_flag);

/*****************************************************************************/
/* verify if the given string is inside the list of existing connection type */
/*****************************************************************************/
/* output: 1=ok, 0=error */
/*************************/
int is_a_valid_cnx(char *t);

#endif
