/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * key.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: key.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __KEY_H__
#define __KEY_H__

/******************************************/
/* access to dc hub is locked using a key */
/************************************************/
/* this function is the highest level function, */
/* it does everything using the given socket    */
/* 1) get the "$Lock xxxx|" from the hub        */
/* 2) compute the "$Key yyyy| reply and send it */
/***********************************************************************/
/* input: socket to use (input to get lock and output to write key)    */
/* output: -1: unable to get $Lock                                     */
/*         -2: no valid string obtained                                */
/*         -3: obtained string is not a string beginning by $Lock      */
/*         -4: ununderstandable $Lock value                            */
/*         -5: lock value to small (never happend, -2 should catch it) */
/*         -6: unable to write $Key to the server                      */
/*         if output!=0 and line!=NULL, (*line) is set to the line     */
/*         received from the hub.                                      */
/*         (*line) must be freed when no more used.                    */
/***********************************************************************/
int unlock_access(int sck,GString **line);

/******************************************/
/* access to dc hub is locked using a key */
/* this function compute and send the key */
/************************************************/
/* medium-level function:                       */
/* same function as previous one except it uses */
/* the given lock instead of taking it from sck */
/* 1) decode the input string                   */
/* 2) compute the "$Key yyyy| reply and send it */
/***********************************************************************/
/* input: socket to use (output to write key)                          */
/*        string "$Lock ....|                                          */
/* output: -1: unable to get $Lock                                     */
/*         -2: no valid string obtained                                */
/*         -3: obtained string is not a string beginning by $Lock      */
/*         -4: ununderstandable $Lock value                            */
/*         -5: lock value to small (never happend, -2 should catch it) */
/*         -6: unable to write $Key to the server                      */
/***********************************************************************/
int do_unlock_access(int sck,GString *lck);

/*************************************************************************/
/* the key is quite easily :) computed from the lock                     */
/* key[x]= ns(lock[x]^lock[x-1])							                      */
/*   ns is a nibble swap (switch the upper 4 bits with the lower 4 bits) */
/* exception:                                                            */
/* key[0] is a bit different                                             */
/* let's name A and B the 2 last bytes of the lock                       */
/* key[0]= ns(lock[0]^A^B^0x05)         ; 0x05 is a kind of magic nibble */
/*************************************************************************/
GString *compute_access_key(GString *lck);

/*****************************************************************************************************/
/* this function computes the key based on c_lock and compares it to input (containing "$Key xxxx|") */
/*****************************************************************************************************/
/* output: 0=ok, 1=$Key keyword not found, 2=wanted and received key do not match */
/**********************************************************************************/
int verify_key(char *c_lock,GString *input, int lazy_mode);

#endif
