
#   $Id: dbftp.pm,v 0.01 2000/12/10 flatline
#
#   Copyright (c) 1994,1995,1996,1997,1998,1999 Tim Bunce
#   portions Copyright (c) 2000 Cristian Giussani
#
#   You may distribute under the terms of either the GNU General Public
#   License or the Artistic License, as specified in the Perl README file,
#   with the exception that it cannot be placed on a CD-ROM or similar media
#   for commercial distribution without the prior approval of the author.

require 5.003;

$DBD::dbftp::VERSION = '0.02';

{
    package DBD::dbftp;

    use DBI ();
    use DynaLoader ();
    use Exporter ();
    @ISA = qw(DynaLoader);

    my $Revision = substr(q$Revision: 2.4 $, 10);

    require_version DBI 1.02;

    bootstrap DBD::dbftp $VERSION;

    $err = 0;		# holds error code   for DBI::err    (XXX SHARED!)
    $errstr = "";	# holds error string for DBI::errstr (XXX SHARED!)
    $drh = undef;	# holds driver handle once initialised

    sub driver{
	return $drh if $drh;
	my($class, $attr) = @_;

	$class .= "::dr";

	# not a 'my' since we use it above to prevent multiple drivers

	$drh = DBI::_new_drh($class, {
	    'Name' => 'dbftp',
	    'Version' => $VERSION,
	    'Err'    => \$DBD::dbftp::err,
	    'Errstr' => \$DBD::dbftp::errstr,
	    'Attribution' => "DBD::dbftp $VERSION by Giussani Cristian",
	    });

	$drh;
    }

sub _OdbcParse($$$) {
    my($class, $dsn, $hash, $args) = @_;
    my($var, $val);
    if (!defined($dsn)) {
        return;
    }
    while (length($dsn)) {
        if ($dsn =~ /([^:;]*)[:;](.*)/) {
            $val = $1;
            $dsn = $2;
        } else {
            $val = $dsn;
            $dsn = '';
        }
        if ($val =~ /([^=]*)=(.*)/) {
            $var = $1;
            $val = $2;
            if ($var eq 'hostname'  ||  $var eq 'host') {
                $hash->{'hostname'} = $val;
            } elsif ($var eq 'db'  ||  $var eq 'dbname') {
                $hash->{'database'} = $val;
            } elsif ($var eq 'DSN') {
                $hash->{'DSN'} = 'DSN=' . $val;
            } else {
                $hash->{$var} = $val;
            }
        } else {
            foreach $var (@$args) {
                if (!defined($hash->{$var})) {
                    $hash->{$var} = $val;
                    last;
                }
            }
        }
    }
}


1;

}


{   package DBD::dbftp::dr; # ====== DRIVER ======
    use strict;

    sub connect {
        my $drh = shift;
        my($dbname, $username, $password, $attrhash)= @_;
        $username = '' unless defined $username;
        $password = '' unless defined $password;

        # create a 'blank' dbh
        my($this, $privateAttrHash);
        $privateAttrHash = {
            'Name' => $dbname,
            'user' => $username,
            'password' => $password
        };

        DBD::dbftp->_OdbcParse($dbname, $privateAttrHash,
                                        ['database', 'hostname', 'port']);

        if (!defined($this = DBI::_new_dbh($drh, {'Name' => $dbname},
                                       $privateAttrHash))) 
        {
           return undef;
        }

        # Call dbftp logon func in dbftp.xs file
        # and populate internal handle data.

        DBD::dbftp::db::_login($this, $dbname, $username, $password) or return undef;

        $this;
    }
 
}


{   package DBD::dbftp::db; # ====== DATABASE ======
    use strict;

    sub prepare {
	my($dbh, $statement, @attribs)= @_;

	# create a 'blank' sth

	my $sth = DBI::_new_sth($dbh, {
	    'Statement' => $statement,
	    });

	DBD::dbftp::st::_prepare($sth, $statement, @attribs)
	    or return undef;

	$sth;
    }


}   # end of package DBD::dbftp::db


{   package DBD::dbftp::st; # ====== STATEMENT ======

    # all done in XS
}

1;

__END__

=head1 NAME

DBD::dbftp - dbftp database driver for the DBI module

=head1 SYNOPSIS

  use DBI;

  $dbh = DBI->connect("dbi:dbftp:DSN=$dbname", $user, $passwd);

  # See the DBI module documentation for full details


=head1 DESCRIPTION

DBD::dbftp is a Perl module which works with the DBI module to provide
access to dbftp ( access to a database via a Windows host running dbtcp ).

=head2 Connection Examples Using DBD::dbftp

See 't/select.t'

=head1 SEE ALSO

L<DBI>

=head1 AUTHOR

DBD::dbftp by Giussani Cristian. DBI by Tim Bunce.

=head1 COPYRIGHT

The DBD::dbftp module is Copyright (c) 2000 Giussani Cristian. Italy.

The DBD::dbftp module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself with the exception that it
cannot be placed on a CD-ROM or similar media for commercial distribution
without the prior approval of the author unless the CD-ROM is primarily a
copy of the majority of the CPAN archive.

=cut
