#include <string>
#include <memory>
#include <ace/Method_Object.h>
#include <ace/Task.h>
#include <ace/Activation_Queue.h>
#include <ace/Synch.h>

using std::string;
using std::auto_ptr;

class DBThreadPool: public ACE_Task<ACE_MT_SYNCH> {

public:

  DBThreadPool(int initThreads, 
	       int minThreads,
	       int maxThreads);
  
  ~DBThreadPool();

  // ACE_Task
  void open(int nthreads);
  void shutdown();
  int svc(void);

  // Do Work
  void submit(ACE_Method_Object *t);
  int reviewThreads(int growBlock);

 // Used by the thread pool
  inline int getQueueSize() { return activation_queue_.method_count(); }
  //inline int getThreads() { return _nthreads.value(); }
  inline string getName() { return _name; }


private:

  int growThreads(int growth);
  int shrinkThreads(int shrink);
  /*  int checkmem(string message);  */
  int updateQueueHistory(int value);

  // Memory control
  //int _initialMemory;
  //int _lastMemory;

  int _nThreads;
  int _initThreads;
  int _minThreads;
  int _maxThreads;

  //const static unsigned int QUEUE_HISTORY_SIZE = 5;
  //int _queueHistory[QUEUE_HISTORY_SIZE];

  // Accounting
  int _growCount;
  int _shrinkCount;
  int _roundsCalm;


  static const int MAX_ROUNDS_CALM = 60;

  string _name;
  //ACE_Atomic_Op<ACE_Thread_Mutex,int> _nthreads;
  ACE_Activation_Queue activation_queue_;
  


};
