<?php
/**
 * This Class will handle comments
 *
 * daCode http://www.dacode.org/
 * src/phplib/comments.php3
 * $Id: comments.php3,v 1.210.2.18 2002/08/06 21:58:00 ruffy Exp $
 *
 * Depends: Config Db Utils Session Html News
 *
 *@author Fabien Penso <penso@linuxfr.org>
 */

Class Comments {

	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * Array of all URLs in all the comments associateed to a resource
	 *@var array
	 */
	var $com_urls;


	/**
	 * HTML rendering package
	 *@var object Html
	 */
	var $html;


	/**
	 * Utils package
	 *@var object Utils
	 */
	var $utils;

	/**
	 * Session handling instance
	 *@var object Session
	 */
	var $session;

	/**
	 * Array of preloaded comments
	 *@var array 
	 */
	var $comments;


	/**
	 * HTTP_REFERER
	 *@var string
	 */
	var $HTTP_REFERER;
	//var $news;

	/**
	 * ID of the resource
	 *@var integer
	 */
	var $news_id;

	/**
	 * The ressource type of the comments looked after
	 *@var integer $res_type 1=news (default),.. to be completed
	 */
	var $res_type = 1;


	/**
	 * User instance
	 *@var object User
	 */
	var $user;

	/**
	 * Admin instance
	 *@var object Admin
	 */
	var $admin;

	/**
	 * Cache abstraction layer
	 *@var object Cache
	 */
	var $cache;

	/**
	 * Constructor
	 *@param mixed $w if not empty, bypasses initialization
	 */
	Function Comments($w="") {
		/* I substituted $news_id by $res_id, since we move from commenting
		 * only news to commenting anything. -- JB
		 */
		global $news_id,$HTTP_SERVER_VARS, $res_type;

		$this->utils = LoadClass('Utils');

		if (!isset($news_id)) $news_id = '';

		$this->utils->debug("Comments:".__LINE__." start; news_id=".$news_id.";\n");

		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->cache = LoadClass('Cache');
		$this->html  = LoadClass('Html');
		$this->user  = LoadClass('User');
		$this->admin = LoadClass('Admin');

		$this->HTTP_REFERER = isset($HTTP_SERVER_VARS['HTTP_REFERER'])?
			$HTTP_SERVER_VARS['HTTP_REFERER']:'';
		$this->comments = array();
		if (empty($w)) {
			if (empty($res_type)) $res_type=1;
			$this->init($news_id, "", $res_type);
		}
		$this->news_id = $news_id;
	}


	/**
	 * Will be used to preload few things ...
	 *@param integer $res_id ID of the resource to which the comments are attached
	 *@param integer $com_id ID of the only comment to get.
	 *@param integer $res_type the type of resource commented
	 *@return integer 0 if $new_id is empty.
	 *@access public
	 */
	Function init($res_id=0,$com_id=0, $res_type=1) {
		global $config;
		$this->utils->debug("Comments:".__LINE__." init: start res_id=".$res_id.
			"; com_id=".$com_id."; res_type=".$res_type."\n");

		if (!empty($res_type)) $this->res_type = $res_type;

		if (empty($res_id)) {
			$this->utils->debug("Comments:".__LINE__." init: res_id is empty, returning\n");
			return 0;
		}

		/* We can choose what comments are preloaded with the parameter $com_id.
		 * - If you want all the comments, you should set it empty:
		 *       $com_id=""
		 * - If you want only one Id, simply set it:
		 *       $com_id=6
		 * - If you know which comments you want to load, use en array:
		 *       $com_id=array(3,5,12,9)
		 */
		if (empty($com_id)) {
			$sqlc_n = "";   // all of them
		} elseif (is_array($com_id)) {
			$sqlc_n = "AND ".$config->tables['comments'].".id IN ('".
				join("','",$com_id)."')";
		} else {
			$sqlc_n = "AND ".$config->tables['comments'].".id='$com_id'";
			// only this one
		}


		/* We Build the SQL Command */
		$sqlc_q = "SELECT ".$config->tables['comments'].".news_id,".
			$config->tables['comments'].".id,".
			$config->tables['comments'].".com_parent,".
			$config->tables['comments'].".subject,".
			$config->tables['comments'].".body,".
			$config->tables['comments'].".timestamp,".
			$config->tables['comments'].".ip,".
			$config->tables['users'].".login,".
			$config->tables['users'].".lname,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".email,".
			$config->tables['users'].".homesite,".
			$config->tables['users'].".param,".
			$config->tables['comments_scored'].".score,".
			$config->tables['comments'].".user_id,".
			$config->tables['sig'].".sig,".
			$config->tables['comments_scored'].".info,".
			$config->tables['comments_scored'].".score_nb ";
		if ($config->moderation_type==2) {
			$sqlc_q .= ",".$config->tables['karma_user'].".experience ";
		}
		$sqlc_q .=	"FROM ". $config->tables['comments'].",".
			$config->tables['comments_scored'].",".
			$config->tables['users'].",".
			$config->tables['sig'];
		if ($config->moderation_type==2) {
			$sqlc_q .= ",".$config->tables['karma_user'];
		}
		$sqlc_q .= 	" WHERE ".$config->tables['comments'].".news_id='".
			addslashes($res_id)."' AND ".
			$config->tables['comments'].".user_id=".
			$config->tables['users'].".id AND ".
			$config->tables['sig'].".id =".
			$config->tables['comments'].".sig_id AND ".
			$config->tables['comments'].".id =".
			$config->tables['comments_scored'].".comments_id  AND ".
			$config->tables['comments'] . ".res_type=$res_type " .
			$sqlc_n;
		if ($config->moderation_type==2) {
			$sqlc_q .= " AND ".$config->tables['karma_user'].".user_id=".
					$config->tables['users'].".id ";
		}
		$sqlc_q .=	" ORDER BY ".$config->tables['comments'].".timestamp";
		// Built ! Pffiou :)

		$ret = $this->db->query($sqlc_q);

		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." init: ".
				lecho("SQL Failed: ").$this->db->error()." SQL:	".
				$sqlc_q."\n");
			exit ;
		}

		$i=0;
		while($row_tmp = $this->db->fetch_array()) {

			$this->comments[$i]['news_id']      = $row_tmp['news_id'];
			$this->comments[$i]['res_type']     = $res_type;
			$this->comments[$i]['id']           = $row_tmp['id'];
			$this->comments[$i]['com_parent']   = $row_tmp['com_parent'];
			$this->comments[$i]['subject']      = $row_tmp['subject'];
			$this->comments[$i]['body']         = $row_tmp['body'];
			$this->comments[$i]['timestamp']    = $row_tmp['timestamp'];
			$this->comments[$i]['ip']           = $row_tmp['ip'];
			$this->comments[$i]['login']        = $row_tmp['login'];
			$this->comments[$i]['lname']        = (isset($row_tmp['lname']))?$row_tmp['lname'] : "";
			$this->comments[$i]['fname']        = (isset($row_tmp['fname']))?$row_tmp['fname'] : "";
			$this->comments[$i]['email']        = $row_tmp['email'];
			$this->comments[$i]['homesite']     = (isset($row_tmp['homesite']))?$row_tmp['homesite'] : "";
			$this->comments[$i]['param']        = $row_tmp['param'];
			$this->comments[$i]['score']        = $row_tmp['score'];
			$this->comments[$i]['user_id']      = $row_tmp['user_id'];
			$this->comments[$i]['sig']          = $row_tmp['sig'];
			$this->comments[$i]['score_info']   = $row_tmp['info'];
			$this->comments[$i]['score_nb']     = $row_tmp['score_nb'];

			if ($config->moderation_type==2) {
				$this->comments[$i]['xp']		= $row_tmp['experience'];
			} else {
				$this->comments[$i]['xp']		= 0;
			}
			$i++;
		}
		$this->db->free();

	}


	/**
	 * New function which will print comment, have to be used with init()
	 *
	 * Creates the HTML for all the comments, or a subtree, and make coffee
	 *
	 *@param integer ID of the first comment
	 *@param integer ID of the parent comment
	 *@param integer scrore threshold
	 *@param string type (one out of 'thread', 'thread' and thread' :) )
	 *@return string the HTML for the comments
	 *@todo better describe the function.
	 *@access public
	 */
	Function com_print2 ($comm_id=0,$com_parent=0,$score=0,$type="thread") {
		global $config;
		static $ulnb=0;
		$this->utils->debug("Comments:".__LINE__." com_print2: start comm_id: ".$comm_id.
			"; com_parent: ".$com_parent."; type = ".$type.";\n");

		$ulmax=9;
		$out = "";
		$tmp = "";

		if (!$com_parent) {
			$out .= $this->html->commentbanner($score, $this->res_type);
		}

		/* If we have no parent comment */
		if ($com_parent==0) {
			if (empty($comm_id)) {
				reset($this->comments);

				while (list (, $val) = each ($this->comments)) {
					$tmp="";
					if ($val['com_parent'] != 0) {
						continue;
					}

					if ($config->moderation_type == 1) {
						if ($val['score'] >= $score) {
					//		$val['com_parent'] == 0) {

							switch($type) {
								case "thread":
									$tmp .= $this->ac($val,$val['news_id'], $this->res_type);
									$tmp .= $this->com_print2(0,$val['id'],$score);
									break;
								default:
									break;
							}
						} elseif ($val['score'] < $score) {
								// $val['com_parent'] == 0) {

							$tmp .= $this->ac($val,$val['news_id'],$this->res_type, "scoredown" );
							$tmp .= $this->com_print2(0,$val['id'],$score);

						} else {
							// $tmp .= "COMPARENT: ".$val['com_parent']."<br />";
							// $tmp .= "Score: ".$val['score']."<br />";
							// $tmp .= $this->com_print2(0,$val['id'],$score);
						}
					} elseif ($config->moderation_type==2) {

						if ($score == '-1' ||
							$score == '0' && $val['score'] >= '0' ||
							$score == '1' && $val['score'] >= $config->last_week_score ||
							$score == '2' && $val['score'] >= (2*$config->last_week_score) ||
							$score == '3' && $val['score'] >= (3*$config->last_week_score) ||
							$score == '4' && $val['score'] >= (4*$config->last_week_score) ||
							$score == '5' && $val['score'] >= (5*$config->last_week_score) ) {
							$tmp .= $this->ac($val,$val['news_id'], $this->res_type);
							$tmp .= $this->com_print2(0,$val['id'],$score);
						} else {
							$tmp .= $this->ac($val,$val['news_id'], $this->res_type,"scoredown");
							$tmp .= $this->com_print2(0,$val['id'],$score);
						}
					}

					if (!empty($tmp)) {
						$out .= $this->html->simplebox($tmp);
					}

				}


			} else {
				reset($this->comments);
				while (list (, $val) = each ($this->comments)) {
					if ($val['id'] == $comm_id) {
						$tmp .= $this->ac($val,$val['news_id'], $this->res_type);
					}
				}
			}

		} else {
			$ulnb++;
			if ($ulnb < $ulmax) {
				$tmp .= "<ul>\n";
			}
			$tmpcomments = $this->comments;
			reset($tmpcomments);
			$ok=0;
			while (list (, $val) = each ($tmpcomments)) {
				if ($val['com_parent'] == $com_parent) {

					if ($config->moderation_type==1) {
						if ($val['score'] >= $score) {
							$tmp .= "<li>".$this->ac($val,$val['news_id'], $this->res_type);
							$tmp .= $this->com_print2(0,$val['id'],$score)."</li>";
							$ok=1;
						} else {
							$tmp .= "<li>".$this->ac($val,$val['news_id'],$this->res_type, "scoredown");
							$tmp .= $this->com_print2(0,$val['id'],$score)."</li>";
							$ok=1;
						}
					} elseif ($config->moderation_type==2) {
						if ($score == '-1' ||
							$score == '0' && $val['score'] >= '0' ||
							$score == '1' && $val['score'] >= $config->last_week_score ||
							$score == '2' && $val['score'] >= (2*$config->last_week_score) ||
							$score == '3' && $val['score'] >= (3*$config->last_week_score) ||
							$score == '4' && $val['score'] >= (4*$config->last_week_score) ||
							$score == '5' && $val['score'] >= (5*$config->last_week_score) )
							{

							$tmp .= "<li>".$this->ac($val,$val['news_id'], $this->res_type);
							$tmp .= $this->com_print2(0,$val['id'],$score)."</li>";
							$ok=1;

						} else {

							$tmp .= "<li>".$this->ac($val,$val['news_id'], $this->res_type, "scoredown");
							$tmp .= $this->com_print2(0,$val['id'],$score)."</li>";
							$ok=1;

						}

					}
				}
			}
			if ($ulnb < $ulmax) {
				$tmp .= "</ul>\n";
			}
			$ulnb--;
			if ($ok) {
				$out .= $tmp;
			}
		}
		$this->utils->debug("Comments:".__LINE__." comm_print2: end\n");
		return $out;
	}
	/**
	 * This function will show the score of the comment
	 *@param array a row out of comments_scored table (?)
	 *@return string the HTML
	 *@access private
	 */
	Function show_score($c) {
		global $config;

		$this->utils->debug("Comments:".__LINE__." show_score: start");

		$tmp = ' (Score: '.$c['score'];

		if ($config->moderation_type == 1) {
			if(!empty($c['score_info']))
				$tmp .= ' - '.$c['score_info'];
		} elseif ($config->moderation_type == 2) {
			$tmp .= "/#".$c['score_nb'];
		}
		$tmp .= ")\n";

		return $tmp;
	}

	/**
	 * This function will set the score. This is when you use system 2
	 * FIXME: can someone explain why all these bloody strings
	 * Calls Exit if user cannot vote, or pb with user, or DB problem
	 *@param string Id of comment we want to set score
	 *@param string the news Id but whuy a bloody string???
	 *@param string the score to set
	 *@param string user ID 
	 *@access public
	 */
	Function set_score($comments_id_tmp="",$news_id_tmp="",$score_id="",
										$localuserid="") {
		global $config;
		$this->utils->debug("Comments:".__LINE__.
			" set_score: start comments_id_tmp=".$comments_id_tmp."; ".
			"news_id_tmp=".$news_id_tmp."; score_id=".$score_id."; localuserid=".
			$localuserid.";\n");

		if (!ereg("^[0-9]+$",$comments_id_tmp) &&
			!ereg("^[0-9]+$",$res_id_tmp) &&
			!ereg("^[0-9]+$",$score_id) &&
			$config->moderation_type != 2) {
			return ;
		}

		if ($localuserid=="" ||
			$this->session->user_id != $localuserid) {
			echo lecho("you bad boy...");
			exit;
		}


		if ($this->session->vote_nb <= 0 ) {
			echo lecho("Can't vote anymore for today!<br />\n");
			exit;
		}


		reset($this->comments);
		$actual_time = time();
		while (list (, $val) = each ($this->comments)) {
			if ($val['id'] == $comments_id_tmp) {
				$timestamp_tmp = mktime(substr($val['timestamp'],8,2),
						substr($val['timestamp'],10,2),substr($val['timestamp'],12,2),
						substr($val['timestamp'],4,2),substr($val['timestamp'],6,2),
						substr($val['timestamp'],0,4));
				if ($timestamp_tmp + 2678400 <= $actual_time) {
					echo lecho("Comment is too old to score! <br />\n");
					exit;
				}
				break;
			}
		}

		$sqlc_q = "SELECT user_id FROM ".$config->tables['comments_scored_user'].
			" WHERE comments_id='".addslashes($comments_id_tmp)."' AND user_id='".
			addslashes($this->session->user_id)."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." set_score:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			echo lecho("It looks like admins are working on the server");
			exit;
		}

		if ($this->db->num_rows()>=1) {
			echo lecho("already voted!");

			exit;
		}

		$sqlc_q = "SELECT score,score_nb FROM ".$config->tables['comments_scored'].
			" WHERE comments_id = '". addslashes($comments_id_tmp)."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." set_score:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			echo lecho("It looks like admins are working on the server");
			exit;
		}

		if ($this->db->num_rows()>=1) {
			$c=$this->db->fetch_array();

			if ($score_id == 1 ||
				$score_id == "-1") {
				$new_score = $c['score'] + $score_id;
			} else {
				echo lecho("you bad boy...");
				exit;
			}

			$new_score_nb = $c['score_nb'] + 1;

			// We remove one vote for this user
			$array_tmp['user_id'] = $this->session->user_id;
			$array_tmp['vote_nb'] = -1;
			$this->session->modify_karma($array_tmp,"+=");

			$sqlc_q = "UPDATE ".$config->tables['comments_scored'].
				" SET score='".addslashes($new_score)."', score_nb='".
				addslashes($new_score_nb)."' WHERE comments_id='".
				addslashes($comments_id_tmp)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Comments:".__LINE__." set_score:".
					lecho("SQL Failed: ").$this->db->error()." SQL: ".
					$sqlc_q."\n");
				echo lecho("It looks like admins are working on the server");
				exit;
			}

			$sqlc_q = "INSERT INTO ". $config->tables['comments_scored_user'].
				" (comments_id,user_id) VALUES ('".addslashes($comments_id_tmp).
				"','".addslashes($this->session->user_id)."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Comments:".__LINE__." set_score:".
					lecho("SQL Failed: ").$this->db->error()." SQL: ".
					$sqlc_q."\n");
				echo lecho("It looks like admins are working on the server");
				exit;
			}

			/*
			 * If user has used a vote, he has 25% to get +1XP
			 */
			mt_srand ((float) microtime() * 1000000);
			$randval = mt_rand(1,4);

			if ($randval == 1) {
				$a['experience'] = $this->session->experience + 1;
				$a['user_id']    = $this->session->user_id;
				$this->session->modify_karma($a);
			}

			/*
			 * Now we raise or lower the karma of the user which is being
			 * scored depending of some variables and lastweek average score.
			 */

			/*
			 * Now we have two way, the comment has been score negative,
			 * or positive.
			 */

			$gain_tmp = 0;
			if ($score_id == 1) {
				// 1/3 chance of gain
				if ($new_score <= $config->last_week_score) {
					mt_srand ((float) microtime() * 1000000);
					$randval = mt_rand(1,3);
					if ($randval == 1) {
						$gain_tmp = 1;
					}
				// 1/2 chance of gain
				} elseif ($new_score <= (2 * $config->last_week_score)) {
					mt_srand ((float) microtime() * 1000000);
					$randval = mt_rand(1,2);
					if ($randval == 1) {
						$gain_tmp = 1;
					}
				// 2/3 chance of a gain
				} elseif ($new_score <= (3 * $config->last_week_score)) {
					mt_srand ((float) microtime() * 1000000);
					$randval = mt_rand(1,6);
					if ($randval <= 4) {
						$gain_tmp = 1;
					}
				// 3/4 chance of a gain
				} elseif ($new_score <= (4 * $config->last_week_score)) {
					mt_srand ((float) microtime() * 1000000);
					$randval = mt_rand(1,8);
					if ($randval <= 6) {
						$gain_tmp = 1;
					}
				// gain +1
				} elseif ($new_score > (4 * $config->last_week_score)) {
					$gain_tmp = 1;
				}
			} elseif ($score_id == "-1") {
				// 1/3 chance of loss
				if ($new_score <= (3 * $config->last_week_score)) {
					mt_srand ((float) microtime() * 1000000);
					$randval = mt_rand(1,3);
					if ($randval == 1) {
						$gain_tmp = -1;
					}
				} elseif ($new_score <= (4 * $config->last_week_score)) {
					mt_srand ((float) microtime() * 1000000);
					$randval = mt_rand(1,4);
					if ($randval == 1) {
						$gain_tmp = -1;
					}
				// gain +1
				} elseif ($new_score > (4 * $config->last_week_score)) {
					$gain_tmp = 0;
				}
			}
			if ($gain_tmp != 0) {
				$sqlc_q = "SELECT user_id FROM ".$config->tables['comments'].
					" WHERE id='".addslashes($comments_id_tmp)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Comments:".__LINE__." set_score:".
						lecho("SQL Failed: ").$this->db->error()." SQL: ".
						$sqlc_q."\n");
					echo lecho("It looks like admins are working on the server");
					exit;
				}
				$c = $this->db->fetch_array();

				$array_tmp = array();
				$array_tmp['user_id'] = $c['user_id'];
				$array_tmp['experience'] = $gain_tmp;
				$this->session->modify_karma($array_tmp,"+=");
			}

		}

	}

	/**
	 * This will display comment
	 * FIXME: public cos used in SubmitComment::preview, but shall it not be private?
	 *@param array $c the row of the comment, as build by init
	 *@param integer $res_id the ressource ID to which it is attached
	 *@param integer $res_type the type of the ressource
	 *@param string $mode "full" to print the comment, "scoredown" to print only the title
	 *@return string the HTML representation of the comments to display
	 *@access public
	 */
	Function ac($c,$res_id, $res_type, $mode ="full") {
		global $config;
		$this->utils->debug("Comments:".__LINE__." ac: start res_id=".$res_id."; res_type=".$res_type."; ".
			"mode=".$mode.";\n");

		$tmp = "";

		// Don t remove this line !
		$tmp_last = "<!-- LASTSEEN:".$c['timestamp']." -->";
		$tmp_last .= $this->user->lastseen_show($c['timestamp']);
		$tmp_last .= "<!-- /LASTSEEN -->";

		$tmp .= "<span class=\"newstext\">\n".$tmp_last.
			' <a name="c'.$c['id'].'"><b>'.$c['subject']."</b></a>\n";

		$tmp .= $this->show_score($c);

		$tmp .= " - " . $this->utils->stamp2date($c['timestamp'],"long")."\n";

		/*	' (Score: '.$c['score'];
		if(!empty($c['score_info']))
			$tmp .= ' - '.$c['score_info'];
		$tmp .= ")\n";*/

		if ($mode=="scoredown") {
			//echo "</td></tr></table>\n";

			return '<a href="'.
					$config->basehref."comments/view.".$config->php.
					"?news_id=$res_id&amp;res_type=$res_type&amp;com_id=".$c['id'].
					"&amp;theme=".$config->theme.
					"\" OnClick=\"window.open('".
						$config->basehref."comments/view.".$config->php.
						"?news_id=".$res_id."&amp;res_type=".$res_type."&amp;com_id=".$c['id'].
						"&amp;res_type=".$res_type."&amp;theme=".$config->theme."',".
						"'comment','".
						'toolbar=no,location=no,directories=no,status=no,'.
						'menubar=no,scrollbars=yes,width=566,height=333'.
						"'); return false;\" ".
					"onmouseout=\"javascript: window.status=''; return true;\" ".
					"onmouseover=\"javascript: window.status='".lecho("View").
					"'; return true;\"".
				">[+]\n</a>".$tmp."</span>\n";
		}

		$c['subject'] = $this->utils->url_conv($c['subject']);
		$c['body'] = $this->utils->url_conv($c['body']);
		$c['sig'] = $this->utils->url_conv($c['sig']);

		$c['body'] = nl2br($c['body']);
		$c['sig'] =  nl2br($c['sig']);


		// Now we choose to show login or fname/lname
		if (($c['param'] & pow(2,0)) && $c['user_id'] != 1 &&
			(!empty($c['lname']) || !empty($c['fname']))) {
			$usermask = $c['fname']." ".$c['lname'];
		} else {
			$usermask = $c['login'];
		}

		if (!empty($c['email'])) {
			$usermail = $c['email'];
		} else {
			$usermail = "";
		}
		if (eregi("^([^@]*)@([^@]*)$",$usermail,$mail_tmp)) {
			$usermail = $mail_tmp[1] . " at " . $mail_tmp[2];
		}

		$timestamp_tmp = mktime(substr($c['timestamp'],8,2),
						substr($c['timestamp'],10,2),substr($c['timestamp'],12,2),
						substr($c['timestamp'],4,2),substr($c['timestamp'],6,2),
						substr($c['timestamp'],0,4));
		// Don t remove this line !
		$tmp .= "<!-- ADMINSCORE:".$c['user_id'].":".$c['id'].":\"".
				$usermask."\":\"".$usermail."\":\"".$c['user_id']."\":\"".
				$timestamp_tmp."\":\"".$c['xp']."\":\"".$c['homesite']."\" -->";
		$tmp .= $this->admin->comments_showscore($c['user_id'],$c['id'],
			$usermask,$usermail,$c['user_id'],$timestamp_tmp,$c['xp'],
			$c['homesite']);
		$tmp .= "<!-- /ADMINSCORE -->\n";



		$tmp .= $c['body'];

		if (!empty($c['sig']) && !$config->hide_sig) {
			$tmp .= "<br /><br />-- <br />\n".$c['sig']."\n";
		}

		// Reply
		$url = $config->basehref.$config->commaddfile.
			"?news_id=$res_id&amp;res_type=$res_type&amp;com_id=".$c['id'];
		return $tmp.'<br />[ <a href="'.$url.
			'" onclick="'."opener.location='$url'; return false;\">".
			lecho("Reply")."</a> ]\n".
			"</span><br />\n";
	}


	/**
	 * This will get all url in comments
	 * Works on Comments::com_url array
	 *@param string text where URL are to look for
	 *@access private
	 */
	Function _com($d) {
		$this->utils->debug("Comments:".__LINE__." _com: start\n");
		$n=preg_match_all('/(f|ht)tps?:\/\/[\w-;\/?:@=&\$.+!*\'\(~#%,]+/i',$d,$t);
		// $d=preg_replace( "/((f|ht)tps?:\/\/[^ \r\n\t]+)/i" , "<a
		// href=\"\\1\">\\1</a>" ,$d);
		for($i=0;$i<$n;$i++) {
			$u = $t[0][$i];
			/*
			 * If the url is not already in the array, we add it
			 */
			if(!isset($l[$u])) {
				$this->com_urls[] = $u;
			}
			$l[$u]=1;
		}
	}

	/**
	 * This will return all the urls from comments
	 * Works on Comments::com_url array
	 *@access public
	 */
	Function get_hrefs() {
		global $config;

		$this->utils->debug("Comments:".__LINE__." get_hrefs: start\n");
		reset($this->comments);
		while (list (, $val) = each ($this->comments)) {
			if ($val['score'] >= $config->score) {
				$this->_com($val['body']);
				$this->_com($val['subject']);
			}
		}

		$tmp_comhrefs = $this->com_hrefs();

		if (!empty($tmp_comhrefs)) {
			return $this->html->sidebox(lecho("Proposed links"),
			$tmp_comhrefs."<br />");
		} else {
			return;
		}
	}

	/**
	 * Shortens URI so that they don't break anything when they are displayed.
	 *@param integer the max length of an URL name
	 *@return string
	 *@access private
	 */
	Function com_hrefs($max_href_chars = 40) {
		$this->utils->debug("Comments:".__LINE__." com_hrefs: start max_href_chars=".$max_href_chars."\n");

		$r = array();
		if (isset($this->com_urls) && is_array($this->com_urls)) {
			reset($this->com_urls);
			while($t=each($this->com_urls)) {
				if(!isset($l[$t[1]])) {
					$l[$t[1]] = 1;
					$r[] = "&nbsp;-&nbsp;<a href=\"".$t[1]."\">";

					$t[1] = eregi_replace("^(https?|ftp)://","",$t[1]);

					if (eregi("^www.",$t[1])) {
						$t[1] = substr ($t[1], 4);
					}

					if (strlen($t[1]) > $max_href_chars) {
						$t[1] = substr ($t[1], 0, $max_href_chars);
						$t[1] .= "&nbsp;(...)";
					}

					$t[1] = ereg_replace("/$","",$t[1]);
					$r[] .= $t[1]."</a><br />";
				}
			}
		}
		return implode("",$r);
	}

	/**
	 * Gets the subject...
	 * FIXME: But why is ID considered a string ?!
	 *@param integer the Id of the comment
	 *@return string the subject
	 *@access public
	 */
	Function get_subject($id) {
		global $config;

		$this->utils->debug("Comments:".__LINE__." get_subject: start id=".$id.";\n");
		$sqlc_q = "SELECT subject FROM ".$config->tables['comments'].
			" WHERE id='".addslashes($id)."'";

		$ret = $this->db->query($sqlc_q);

		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." get_subject: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".$sqlc_q."\n");
			exit;
		}

		$row = $this->db->fetch_array();

		return $row['subject'];
	}

	/**
	 * Function to modify score
	 * Calls exit on DB problem
	 *@param array a row in comments_scored table
	 *@access public
	 */
	Function mod_score($row) {
		global $config;

		$this->utils->debug("Comments:".__LINE__." mod_score: start\n");
		$sqlc_q = "UPDATE ".$config->tables['comments_scored']." SET ".
			"user_id='".addslashes($this->session->user_id)."',".
			"score='".addslashes($row['score'])."',".
			"info='".addslashes($row['info'])."' WHERE ".
			"comments_id='".addslashes($row['comments_id'])."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." mod_score: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			exit;
		}
	}


	
	// These `Load N Show' functions are used to select Nodes of comments
	//     in the SQL database and to print these selections. A Branch
	//      is a List of comments (the last one is $com_id), and a Subtree
	//      is Tree of comments (the root is $com_id).
	//

	/**
	 * Loads all the ancestors of com_id
	 * Calls exit on SQL failure
	 *@param integer $res_id ID of the resource
	 *@param integer $com_id ID of the comment
	 *@param integer $res_type type of the resource (see Config::resources)
	 *@param string $list how the commetns are listed :last or all (default)
	 *@return array a list of comments
	 *@access private
	 */
	Function load_branch($res_id,$com_id, $res_type, $list='all') {
		global $config;
		$this->utils->debug("Comments:".__LINE__." load_branch: start; res_id=".
				$res_id."; com_id=".$com_id."; res_type=".$res_type.
				"; list=".$list.";\n");
	
		$branch = array();
		$sqlc_q = "SELECT id,com_parent".
			 " FROM ".$config->tables['comments'];
	
		if ($list=='last') {
			$sqlc_q .= " WHERE id='".addslashes($com_id)."'";
		} else {
			$sqlc_q .= " WHERE news_id='".addslashes($res_id).
				"' AND id<='".addslashes($com_id).
				"' AND res_type=$res_type " .
				" ORDER BY id DESC";
		}
	
		$ret = $this->db->query($sqlc_q);

		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." load_branch:	".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			exit;
		}

		$expected_node = $com_id;
		while(list($id,$father) = $this->db->fetch_array()) {
			if ($expected_node==$id) {
				$branch[] = $id;
				$expected_node = $father;
			}
		}
		$this->db->free();

		return $branch;
	}
	
	/**
	 * Loads the subtree  - all the heirs - of a comment
	 * Calls exit on DB failure
	 *@param integer $res_id the resource ID the comment is attached to
	 *@param integer $res_type the type of resource
	 *@param integer $com_id the ID of the comment
	 *@retrun array a tree of comments
	 *@access private
	 */
	Function load_subtree($res_id, $res_type, $com_id) {
		global $config;
		$this->utils->debug("Comments:".__LINE__." load_subtree: start; res_id=".
			$res_id."; com_id=".$com_id."; res_type=".$res_type.";\n");
		$sqlc_q = "SELECT id,com_parent".
			" FROM ".$config->tables['comments'].
			" WHERE news_id='".addslashes($res_id)."' AND ".
			"id>'".addslashes($com_id)."'".
			"AND res_type=$res_type " .
			" ORDER BY id ASC";

		$ret = $this->db->query($sqlc_q);

		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." load_subtree:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			exit;
		}

		$node_in_subtree[$com_id]=1;
		$set=array();
		$subtree=array();
		while(list($id,$father) = $this->db->fetch_array()) {
			if (isset($node_in_subtree[$father]) &&
					$node_in_subtree[$father]) {
				$subtree[$father][] = $id;
				$node_in_subtree[$id] = 1;
				$set[] = $id;
			}
		}

		$this->db->free();

		$this->init($res_id,$set,$res_type);
		return $subtree;
	}

	/**
	 * Create the HTML to show all the ancestors of a comment
	 *@param integer $res_id ID of the resource
	 *@param integer $com_id ID of the comment
	 *@param integer $res_type type of the resource (see Config::resources)
	 *@param string $list how the comments are listed (last | all (default))
	 *@return string the HTML
	 *@access public
	 */

	Function show_branch($res_id,$com_id, $res_type, $list='all') {
		$this->utils->debug("Comments:".__LINE__." show_branch: start; res_id=".
			$res_id."; com_id=".$com_id."; res_type=".$res_type."; ".
			"list=".$list.";\n");

		$branch = $this->load_branch($res_id, $com_id, $res_type, $list);
		$this->init($res_id,$branch, $res_type);
		rsort($branch);
		reset($branch);
		$out = '';
		while (list($k,$v) = each($branch)) {
			$out .= " <li>\n".
				"  ".$this->ac(
					$this->comments[$k],
					$this->comments[$k]['news_id'],
					$res_type,
					"full"
					)."\n".
				" </li>\n";
		}

		/*
		 * Here you can see comment's context or branch.
		 * It's a list whose last element is the comment
		 * referenced '$com_id' in the URL.
		 */
		return $this->html->simplebox("<ul>\n$out</ul>\n");
	}

	/**
	 * Creates the HTML for the subtree of $com_id (all heirs of $com_id)
	 *@param integer ID of the resource
	 *@param integer type of the resource (see Config::resources)
	 *@param integer ID of the comment
	 *@return string HTML for the subtree
	 *@access public
	 */
	Function show_subtree($res_id, $res_type,$com_id) {
		$this->utils->debug("Comments:".__LINE__." show_subtree: start; res_id=".
			$res_id."; com_id=".$com_id."; res_type=".$res_type.";\n");
		$subtree = $this->load_subtree($res_id, $res_type, $com_id);
		if (!empty($subtree)) {
			$out = lecho("Here you can see the <b>subtree</b>").
				lecho(" of the <b>node</b> numbered ").$com_id.".\n".
				$this->html->simplebox($this->com_print2(0,$com_id));
		} else {
			$out = lecho("No <b>subtree</b> for the <b>node</b> number ").$com_id;
			$out .= "\n";
		}
		return $out;
	}

	/**
	 * Returns the number of comments
	 *@param integer $res_id the ID of the ressource to which the commetns are attached
	 *@param integer $res_type the type of the ressource
	 *@param string score the threshold for counting comments. -2 => default.
	 *@access public
	 */
	Function count_comments($res_id, $res_type=1, $score="-2") {
		global $config;

		$this->utils->debug("Comments:".__LINE__." count_comments: start; res_id=".
			$res_id."; res_type=".$res_type."; score=".$score.";\n");

		$out = array();
		$sqlc_q = "SELECT COUNT(*),".$config->tables['comments'].
			".news_id FROM ".$config->tables['comments'].
			", ".$config->tables['comments_scored'].
			" WHERE (";
		if (gettype($res_id) == "array" && sizeof($res_id) >= 0) {
			reset($res_id);
			$sqlc_q .= "(";
			while($tmpo=current($res_id)) {
				$sqlc_q .= $config->tables['comments'].
					".news_id='".addslashes($tmpo['id'])."'";
				if (next($res_id)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ") AND ";
		} else if (gettype($res_id) != "array") {
			$sqlc_q .= $config->tables['comments'].".news_id='".addslashes($res_id)."' AND ";
		} else {
			return $out;
		}

		if ($score != "-2") {
			$sqlc_q .= $config->tables['comments_scored'].
					".score >= '".addslashes($score)."' AND ";
		}

		$sqlc_q .= $config->tables['comments_scored'].".comments_id=".
				$config->tables['comments'].".id ";

		$sqlc_q .= ") AND ". $config->tables['comments'] .".res_type=$res_type";

		$sqlc_q .= " GROUP BY ".$config->tables['comments'].".news_id";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." count_comments:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			exit;
		}
		$i = 1;
		while ($row = $this->db->fetch_array()) {
			$out[$i] = $row;
			$i++;
		}
		$this->db->free();

		if (gettype($res_id) == "array") {
			return $out;
		} elseif (isset($out[1])) {
			return $out[1][0];
		} else {
			return 0;
		}
	}

	/**
	 * Returns the number of comments in an hash array
	 *     => array [$res_id]["s".$score]
	 *@param array $res_id the ids to which the comments are attached
	 *@param integer $res_type the ressource type
	 *@return array
	 *@access public
	 */
	Function count_comments_array($res_id, $res_type=1 ) {
		global $config;

		$out = array();
		$sqlc_q = "SELECT ".$config->tables['comments'].".news_id,".
			$config->tables['comments_scored'].".score,COUNT(*)".
			" FROM ".$config->tables['comments'].
			",".$config->tables['comments_scored'].
			" WHERE (";
		if (gettype($res_id) == "array" && sizeof($res_id) > 0) {
			reset($res_id);
			$array_news = $res_id;
			$sqlc_q .= "(";
			while($tmpo=current($res_id)) {
				$sqlc_q .= $config->tables['comments'].
					".news_id='".addslashes($tmpo['id'])."'";
				if (next($res_id)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ") AND ";
		} else if (gettype($res_id) != "array") {
			$sqlc_q .= $config->tables['comments'].".news_id='".addslashes($res_id)."' AND ";
			$array_news = array();
			$array_news[0] = array('id' => $res_id);
		} else {
			return $out;
		}

		$sqlc_q .= $config->tables['comments_scored'].".comments_id=".
				$config->tables['comments'].".id ";

		$sqlc_q .= ") AND ". $config->tables['comments'] . ".res_type=$res_type ";

		$sqlc_q .= " GROUP BY ".
			$config->tables['comments'].".news_id,".
			$config->tables['comments_scored'].".score";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." count_comments_array:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			exit;
		}
		reset($array_news);
		while ($n = current($array_news)) {
			$out['n'.$n['id']] = array(
				"s-1" => 0,
				"s0" => 0,
				"s1" => 0,
				"s2" => 0,
				"s3" => 0,
				"s4" => 0,
				"s5" => 0,
				"s6" => 0
			);
			next($array_news);
		}

		$maxscore_tmp = '0';

		while ($row = $this->db->fetch_array()) {
			$n = $row['news_id'];
			$s = $row['score'];
			if ($config->moderation_type == 1) {
				$out['n'.$n]['s'.$s] = $row[2];
			} elseif ($config->moderation_type == 2) {
				if ($s >= (5*$config->last_week_score)) {
					$out['n'.$n]['s5'] += $row[2];
				}
				if ($s >= (4*$config->last_week_score)) {
					$out['n'.$n]['s4'] += $row[2];
				}
				if ($s >= (3*$config->last_week_score)) {
					$out['n'.$n]['s3'] += $row[2];
				}
				if ($s >= (2*$config->last_week_score)) {
					$out['n'.$n]['s2'] += $row[2];
				}
				if ($s >= $config->last_week_score) {
					$out['n'.$n]['s1'] += $row[2];
				}
				if ($s >= 0) {
					$out['n'.$n]['s0'] += $row[2];
				}
				$out['n'.$n]['s-1'] += $row[2];
			}

			if (empty($maxscore_tmp) ||
				$maxscore_tmp < $row['score']) {
				$maxscore_tmp = $row['score'];
			}
		}
		$this->db->free();


		if ($config->moderation_type == 1) {
			reset($array_news);
			while ($n = current($array_news)) {
				$nid = $n['id'];
				for ($i=$maxscore_tmp;$i>=-1;$i--) {
					$prev = $i+1;
					$out['n'.$nid]['s'.$i] += $out['n'.$nid]['s'.$prev];
				}
				next($array_news);
			}
		}
		return $out;
	}


	/**
	 * This mypost function is used to get info on yours recents Posts.
	 * Some useful info on your post will be displayed.
	 * And there is a link to the view of each post :
	 *      href=comments/thread.php3
	 *@param string order The order comments should be displayed
	 *@param string user_id The (option) user_id to be displayed
	 *@return string HTML code
	 *@access public
	 */
	Function mypost($order="id", $user_id="") {
		global $config;

		$this->utils->debug("Comments:".__LINE__." mypost start order=".$order." user_id=".$user_id."\n");

		if ($user_id == "") {
			// it's us
			
			$sqlc_u = "user_id='".addslashes($this->session->user_id)."'";
			$mypost_uid = $this->session->user_id;
		} elseif (preg_match('/[0-9]*/', $user_id) && !$config->disable_view_comments) {
			// it's a user_id
			$sqlc_u = "user_id='".addslashes($user_id)."'";
			$mypost_uid = $user_id;
		} elseif ($config->disable_view_comments) {
			$tmp = lecho("Sorry, viewing other people's comments has been disabled by the administrator");
			return $tmp;
		} else {
			$tmp = lecho("You have provided a wrong user_id .. sorry");
			return $tmp;
		}

		$max_selection = 10;  // The max you can select. sqlchecked because it is const;
		$this->user_id = $this->user->user_id;

		/* We check if params look fines */
		$fields = array("subject","news_id","id","timestamp", "res_type");
		if (!ereg('^('.join('|',$fields).')$' , $order)) {
			return "<tr><td class=\"boxheader\"> Order was: ".$order." ".
				lecho("not checked, not a field")."</td></tr>\n";
		}
		// $order= is sqlchecked now, must be in $fields;

		// Ordering by news_id does'nt have any sense now.
		// So if the user asks this, we order by the tuple
		// res_type, res_id -- which is named news_id here for historical
		// reasons...
		if ($order == "news_id") $order = "res_type, news_id";

		/* ONE : We select what comments are interesting */
		$sqlc_q = 'SELECT '. join(",",$fields).
			' FROM '.$config->tables['comments'].
			" WHERE ".$sqlc_u." ORDER BY $order DESC ".
			$this->db->compat_limit($max_selection);

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." mypost:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			exit;
		}
		if ($this->db->num_rows() == 0) {
			$this->db->free();
			return "<tr><td class=\"boxheader\">".lecho("not yet a poster???").
				"</td></tr>";
		}
		while($c = $this->db->fetch_array()) {
			$set_of_comments[] = $c;
			$set_of_news[] = array('res_type' => $c['res_type'],
														'res_id' => $c['news_id']);
			$resourceSet[$c['res_type']][] = $c['news_id'];
			//$c[news_id] above is NOT a mistake.
		}
		$this->db->free();

		/* TWO: We get more infos for the selected set of news */
			// we want the Title...
		//CAreful about ressource
		//$news_title is there for historic reasons, it's the arrays
		// of the resources 'short views'.
		// Btw, we use it to build the node query
		$sql_where = array();
		reset($resourceSet);
		while ( list ($res_type, $res_ids) = each($resourceSet) ) {
			$topics =LoadClass($config->resources[$res_type]);
			reset($res_ids);
			while ( list(, $res_id) = each ($res_ids)) {
				$news_title[$res_type][$res_id] = $topics->viewShort($res_id);
			}

			// Building the node query...
			$sql_where[] = "( res_type=$res_type AND news_id IN (".
				join(",", $res_ids) . ") )";
		}

		// ... and we want the Tree of the news.
		reset($set_of_news);
		$sqlc_q = "SELECT id,com_parent,timestamp".
			" FROM ".$config->tables['comments'].
			" WHERE " . join(" OR ", $sql_where);
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Comments:".__LINE__." mypost:".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			exit;
		}
		while($node = $this->db->fetch_array()) {
			// ugly PHP3 :-(
			$tree[$node['id']] = array($node['com_parent'],$node['timestamp'],0,0);
			// PHP4 not tested : $tree[array_pop($node)] = $node;
		}
		$this->db->free();
		$tree[0] = array(0,0,0,0);
		krsort($tree);
		reset($tree);
		while (list($id,$node) = each($tree)) {
			$tree[$node['0']]['2'] += 1+$node['2'];
			$max = ($node['3'] ? $node['3'] : $node['1']);
			if ($max > $tree[$node['0']]['3']) {
				$tree[$node['0']]['3'] = $max;
			}
		}
		/* now, a node is
		 *      0=> the id of its parent,
		 *      1=> the timestamp of the node,
		 *      2=> the size of its subtree,
		 *      3=> the max(timestamp) of all nodes of its subtree.
		 */

		/* THREE: We process the output */
		// we process each line of the table ...
		$cellnocomment = "  <td class=\"boxtext\">\n".
					'   0 '.lecho("comment")."\n".
					"  </td>\n";
		reset($set_of_comments);
		$out = "";
		while(list($k,$c) = each($set_of_comments)) {
			//$news_id still there instead of $res_id, i'm lazy :) -- JB
			list($subject,$news_id,$com_id,$timestamp, $res_type) = $c;
			$count = 0; // the size of the branch
			$n = $com_id;
			while ($tree[$n][0] > 0) {
				$n = $tree[$n][0];
				$count++;
			}
			$out .= " <tr>\n".
				'  <td class="boxtext">'.$news_title[$res_type][$news_id]."</td>\n".
				"  <td class=\"boxtext\">\n".
				"   <b>\n".
				'    <a href="'.$config->basehref.'comments/thread.'.$config->php.
				'?news_id='.$news_id.'&amp;com_id='.$com_id. '&amp;res_type=' . $res_type.
				'">'.$subject.'</a>'."\n".
				"   </b>\n".
				"  </td>\n".
				"  <td class=\"boxtext\">".$this->utils->stamp2date($timestamp,"long").
				"</td>\n".

				($count==0 ? $cellnocomment :  // cell before
				"  <td class=\"boxtext\">\n".
				'   <a href="'.$config->basehref.'comments/thread.'.$config->php.
					"?news_id=$news_id&amp;com_id=$com_id&amp;res_type=$res_type&amp;before=1".
					"\">$count ".
					($count>1?lecho("comments"):lecho("comment"))."</a>\n".
				'   <br />- '.$this->utils->interval($tree[$n][1],$timestamp)."\n".
				"  </td>\n"
				).

				($tree[$com_id][2]==0 ? $cellnocomment :  // cell after
				"  <td class=\"boxtext\">\n".
				'   <a href="'.$config->basehref.'comments/thread.'.$config->php.
					"?news_id=$news_id&amp;com_id=$com_id&amp;res_type=$res_type&amp;after=1".
					'">'.$tree[$com_id][2].' '.
					($tree[$com_id][2]>1?lecho("comments"):lecho("comment"))."</a>\n".
				'   <br />+ '.$this->utils->interval($timestamp,$tree[$com_id][3]).
				"\n".
				"  </td>\n"
				).

				" </tr>\n";
		}

			// ... and we add the header of the table
		if ($out) {
			$TH_ORDER = '  <th class="boxheader"><a class="boxheader" href="'.
				$config->basehref."users/posts.".$config->php.'?user_id='.$mypost_uid.
				'&amp;order';

			return " <tr>\n".
				$TH_ORDER."=news_id\">Discussion</a></th>\n".
				$TH_ORDER."=subject\">".lecho("Subject")."</a></th>\n".
				$TH_ORDER."=id\">".lecho("on")."</a></th>\n".
				"  <th class=\"boxheader\">".lecho("before")."</th>\n".
				"  <th class=\"boxheader\">".lecho("after")."</th>\n".
				" </tr>\n".$out;
		} else {
			return "<tr><td class=\"boxheader\">".lecho("no result")."</td></tr>\n";
		}
	}


	/**
	 * This function determines the number of comments in a human-readable way
	 * (that is, returns n comments, taking care of plural.)
	 * Subsidiary question: this is adapted for most (all?) european laguages. What 
	 * happens with arabic, chinese or whatever?
	 *@param integer the ID of the ressource
	 *@param integer the type of the resource
	 *@param integer the minimal score for counting comments, -2 to get default score.
	 *@access public
	 */
	function numberOfComments($resId, $resType, $score = -2) {
		$noc = $this->count_comments($resId, $resType, $score);
		if ($noc > 1) { //We got plural form
			$text = lecho("comments");
		} else { //singular
			$text = lecho("comment");
		}
		$text = $noc . " " . $text; 
		return $text;
	}

}

?>
