(in-package "ACL2")

(local (include-book "ground-zero"))
;(local (include-book "fl"))
(local (include-book "rationalp"))
(local (include-book "fp2"))
(local (include-book "flooreric"))
(local (include-book "predicate"))
(local (include-book "product"))

;(DEFUN FL (X) (FLOOR X 1))

(defthm mod-rational-when-y-is-rational-rewrite
  (implies (and (rationalp y)
                (case-split (acl2-numberp x)))
           (equal (rationalp (mod x y))
                  (rationalp x)))
  :hints (("Goal" :in-theory (enable mod)))
)


(defthm mod-with-x-a-non-acl2-number-is-zero
  (implies (not (acl2-numberp x))
           (equal (mod x y)
                  0))
  :hints (("Goal" :in-theory (enable mod))))

;rewrite?
(defthm mod-non-negative-rationalp-type-prescription
  (implies (and (case-split (<= 0 y)) ;case-split?
                (case-split (not (equal 0 y)))
                (case-split (rationalp x))
                (case-split (rationalp y))
                )
           (and (<= 0 (mod x y))
                (rationalp (mod x y))))
  :hints (("Goal" :in-theory (enable mod)))
  :rule-classes (:type-prescription)
)


#|
(defthm mod-negative-rewrite
  (implies (and ;(< 0 y)
                (case-split (rationalp y))
                (case-split (rationalp x)))
           (implies (< (mod x y) 0)
                    (and (not (integerp (* x (/ y))))
                         (< y 0)
                         )))
  :rule-classes nil
  :hints (("Goal" :in-theory (enable mod)))
)
|#




#|(defthm mod-complex-rationalp
  (implies (rationalp y)
           (equal (complex-rationalp (mod x y))
                  (complex-rationalp x))))



|#

(defthm mod-upper-bound
  (implies (and (case-split (not (complex-rationalp x))) ;(rationalp x)
                (case-split (rationalp y))
                (case-split (< 0 y))
                )
           (< (mod x y) y))
  :hints (("Goal" :in-theory (enable mod) :cases ((rationalp x))))
  :rule-classes (:rewrite (:linear :trigger-terms ((mod x y))))
)


(defthm mod-integerp
  (implies (and (integerp x)
                (integerp y)
                )
           (integerp (mod x y)))
  :hints (("Goal" :in-theory (enable mod)))
  :rule-classes (:rewrite :type-prescription))

;what about when x is a known int?
(defthm mod-integerp-2
  (implies (and (integerp y)
                (case-split (acl2-numberp x))
                )
           (equal (integerp (mod x y))
                  (integerp x)))
  :hints (("Goal" :in-theory (enable mod))))


(defthm mod-with-i-zero
  (equal (mod 0 j)
         0)
  :hints (("Goal" :in-theory (enable mod))))

(defthm mod-with-j-zero
  (implies (case-split (acl2-numberp j))
           (equal (mod j 0)
                  j))
  :hints (("Goal" :in-theory (enable mod))))

;change name
(defthm mod-RATIONAL
    (implies (case-split (rationalp m))
	     (rationalp (mod m n)))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :in-theory (enable mod))))