/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.ControlRecordUtils;

public final class ControlRecord {
    private final ControlRecordType recordType;
    private final ApiMessage message;

    public static ControlRecord of(ByteBuffer key, ByteBuffer value) {
        ControlRecordType recordType = ControlRecordType.parse((ByteBuffer)key);
        LeaderChangeMessage message = switch (recordType) {
            case ControlRecordType.LEADER_CHANGE -> ControlRecordUtils.deserializeLeaderChangeMessage((ByteBuffer)value);
            case ControlRecordType.SNAPSHOT_HEADER -> ControlRecordUtils.deserializeSnapshotHeaderRecord((ByteBuffer)value);
            case ControlRecordType.SNAPSHOT_FOOTER -> ControlRecordUtils.deserializeSnapshotFooterRecord((ByteBuffer)value);
            case ControlRecordType.KRAFT_VERSION -> ControlRecordUtils.deserializeKRaftVersionRecord((ByteBuffer)value);
            case ControlRecordType.KRAFT_VOTERS -> ControlRecordUtils.deserializeVotersRecord((ByteBuffer)value);
            default -> throw new IllegalArgumentException(String.format("Unknown control record type %s", recordType));
        };
        return new ControlRecord(recordType, (ApiMessage)message);
    }

    public static ControlRecord of(ApiMessage message) {
        ControlRecordType recordType;
        if (message instanceof LeaderChangeMessage) {
            recordType = ControlRecordType.LEADER_CHANGE;
        } else if (message instanceof SnapshotHeaderRecord) {
            recordType = ControlRecordType.SNAPSHOT_HEADER;
        } else if (message instanceof SnapshotFooterRecord) {
            recordType = ControlRecordType.SNAPSHOT_FOOTER;
        } else if (message instanceof KRaftVersionRecord) {
            recordType = ControlRecordType.KRAFT_VERSION;
        } else if (message instanceof VotersRecord) {
            recordType = ControlRecordType.KRAFT_VOTERS;
        } else {
            throw new IllegalArgumentException(String.format("Unknown control record type %s", message.getClass()));
        }
        return new ControlRecord(recordType, message);
    }

    private ControlRecord(ControlRecordType recordType, ApiMessage message) {
        this.recordType = recordType;
        this.message = message;
    }

    public ControlRecordType type() {
        return this.recordType;
    }

    public ApiMessage message() {
        return this.message;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ControlRecord that = (ControlRecord)other;
        return Objects.equals(this.recordType, that.recordType) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.recordType, this.message);
    }

    public String toString() {
        return String.format("ControlRecord(recordType=%s, message=%s)", this.recordType, this.message);
    }
}

