/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Element;

public class GradientExtensionHandler
extends DefaultExtensionHandler {
    public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext genCtx) {
        if (paint instanceof LinearGradientPaint) {
            return this.getLgpDescriptor((LinearGradientPaint)paint, genCtx);
        }
        if (paint instanceof RadialGradientPaint) {
            return this.getRgpDescriptor((RadialGradientPaint)paint, genCtx);
        }
        return super.handlePaint(paint, genCtx);
    }

    private SVGPaintDescriptor getRgpDescriptor(RadialGradientPaint gradient, SVGGeneratorContext genCtx) {
        Element gradElem = genCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "radialGradient");
        String id = genCtx.getIDGenerator().generateID("gradient");
        gradElem.setAttribute("id", id);
        Point2D centerPt = gradient.getCenterPoint();
        gradElem.setAttribute("cx", String.valueOf(centerPt.getX()));
        gradElem.setAttribute("cy", String.valueOf(centerPt.getY()));
        Point2D focusPt = gradient.getFocusPoint();
        gradElem.setAttribute("fx", String.valueOf(focusPt.getX()));
        gradElem.setAttribute("fy", String.valueOf(focusPt.getY()));
        gradElem.setAttribute("r", String.valueOf(gradient.getRadius()));
        this.addMgpAttributes(gradElem, genCtx, gradient);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", gradElem);
    }

    private SVGPaintDescriptor getLgpDescriptor(LinearGradientPaint gradient, SVGGeneratorContext genCtx) {
        Element gradElem = genCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        String id = genCtx.getIDGenerator().generateID("gradient");
        gradElem.setAttribute("id", id);
        Point2D startPt = gradient.getStartPoint();
        gradElem.setAttribute("x1", String.valueOf(startPt.getX()));
        gradElem.setAttribute("y1", String.valueOf(startPt.getY()));
        Point2D endPt = gradient.getEndPoint();
        gradElem.setAttribute("x2", String.valueOf(endPt.getX()));
        gradElem.setAttribute("y2", String.valueOf(endPt.getY()));
        this.addMgpAttributes(gradElem, genCtx, gradient);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", gradElem);
    }

    private void addMgpAttributes(Element gradElem, SVGGeneratorContext genCtx, MultipleGradientPaint gradient) {
        gradElem.setAttribute("gradientUnits", "userSpaceOnUse");
        switch (gradient.getCycleMethod()) {
            case REFLECT: {
                gradElem.setAttribute("spreadMethod", "reflect");
                break;
            }
            case REPEAT: {
                gradElem.setAttribute("spreadMethod", "repeat");
                break;
            }
            case NO_CYCLE: {
                gradElem.setAttribute("spreadMethod", "pad");
            }
        }
        switch (gradient.getColorSpace()) {
            case LINEAR_RGB: {
                gradElem.setAttribute("color-interpolation", "linearRGB");
                break;
            }
            case SRGB: {
                gradElem.setAttribute("color-interpolation", "sRGB");
            }
        }
        AffineTransform tf = gradient.getTransform();
        if (!tf.isIdentity()) {
            String matrix = "matrix(" + tf.getScaleX() + " " + tf.getShearY() + " " + tf.getShearX() + " " + tf.getScaleY() + " " + tf.getTranslateX() + " " + tf.getTranslateY() + ")";
            gradElem.setAttribute("gradientTransform", matrix);
        }
        Color[] colors = gradient.getColors();
        float[] fracs = gradient.getFractions();
        for (int i = 0; i < colors.length; ++i) {
            Element stop = genCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "stop");
            SVGPaintDescriptor pd = SVGColor.toSVG((Color)colors[i], (SVGGeneratorContext)genCtx);
            stop.setAttribute("offset", (int)(fracs[i] * 100.0f) + "%");
            stop.setAttribute("stop-color", pd.getPaintValue());
            if (colors[i].getAlpha() != 255) {
                stop.setAttribute("stop-opacity", pd.getOpacityValue());
            }
            gradElem.appendChild(stop);
        }
    }
}

